/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.util.FindAnnotation;

public final class PickConstructor {
    public static Constructor pickSingletonConstructor(Class clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        Object constructor = null;
        int numParameters = 0;
        Constructor<?> pick = null;
        boolean potentialConflict = false;
        for (Constructor<?> con : constructors) {
            if (!Modifier.isPublic(con.getModifiers()) || con.getParameterTypes().length < numParameters) continue;
            if (con.getParameterTypes().length > numParameters) {
                potentialConflict = false;
            }
            boolean noContextAnnotation = false;
            if (con.getParameterAnnotations() != null) {
                for (Annotation[] ann : con.getParameterAnnotations()) {
                    if (FindAnnotation.findAnnotation(ann, Context.class) != null) continue;
                    noContextAnnotation = true;
                }
            }
            if (noContextAnnotation) continue;
            if (con.getParameterTypes().length == numParameters && numParameters != 0) {
                potentialConflict = true;
            }
            numParameters = con.getParameterTypes().length;
            pick = con;
        }
        if (potentialConflict) {
            LogMessages.LOGGER.ambiguousConstructorsFound(clazz);
        }
        return pick;
    }

    public static Constructor pickPerRequestConstructor(Class clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        Constructor<?>[] declaredConstructors = clazz.getDeclaredConstructors();
        Object constructor = null;
        int numParameters = 0;
        Constructor<?> pick = null;
        boolean potentialConflict = false;
        for (Constructor<?> con : constructors) {
            if (!Modifier.isPublic(con.getModifiers()) || con.getParameterTypes().length < numParameters) continue;
            if (con.getParameterTypes().length > numParameters) {
                potentialConflict = false;
            }
            boolean noContextAnnotation = false;
            if (con.getParameterAnnotations() != null) {
                for (Annotation[] ann : con.getParameterAnnotations()) {
                    if (FindAnnotation.findJaxRSAnnotations(ann).length != 0) continue;
                    noContextAnnotation = true;
                }
            }
            if (noContextAnnotation) continue;
            if (con.getParameterTypes().length == numParameters && numParameters != 0) {
                potentialConflict = true;
            }
            numParameters = con.getParameterTypes().length;
            pick = con;
        }
        if (potentialConflict) {
            LogMessages.LOGGER.ambiguousConstructorsFound(clazz);
        }
        return pick;
    }
}

