/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.remoting.AbstractOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.AbstractOutboundConnectionService;
import org.jboss.as.remoting.ConnectorUtils;
import org.jboss.as.remoting.RemoteOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.RemoteOutboundConnectionService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.xnio.OptionMap;

class RemoteOutboundConnectionAdd
extends AbstractAddStepHandler {
    static final RemoteOutboundConnectionAdd INSTANCE = new RemoteOutboundConnectionAdd();

    private RemoteOutboundConnectionAdd() {
        super(RemoteOutboundConnectionResourceDefinition.ATTRIBUTE_DEFINITIONS);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode fullModel = Resource.Tools.readModel((Resource)resource);
        this.installRuntimeService(context, fullModel);
    }

    void installRuntimeService(OperationContext context, ModelNode fullModel) throws OperationFailedException {
        String connectionName = context.getCurrentAddressValue();
        String outboundSocketBindingRef = RemoteOutboundConnectionResourceDefinition.OUTBOUND_SOCKET_BINDING_REF.resolveModelAttribute(context, fullModel).asString();
        ServiceName outboundSocketBindingDependency = context.getCapabilityServiceName("org.wildfly.network.outbound-socket-binding", outboundSocketBindingRef, OutboundSocketBinding.class);
        OptionMap connOpts = ConnectorUtils.getOptions(context, fullModel.get("property"));
        String username = RemoteOutboundConnectionResourceDefinition.USERNAME.resolveModelAttribute(context, fullModel).asStringOrNull();
        String securityRealm = RemoteOutboundConnectionResourceDefinition.SECURITY_REALM.resolveModelAttribute(context, fullModel).asStringOrNull();
        String authenticationContext = RemoteOutboundConnectionResourceDefinition.AUTHENTICATION_CONTEXT.resolveModelAttribute(context, fullModel).asStringOrNull();
        String protocol = authenticationContext != null ? null : RemoteOutboundConnectionResourceDefinition.PROTOCOL.resolveModelAttribute(context, fullModel).asString();
        ServiceName serviceName = AbstractOutboundConnectionResourceDefinition.OUTBOUND_CONNECTION_CAPABILITY.getCapabilityServiceName(new String[]{connectionName});
        ServiceName aliasServiceName = RemoteOutboundConnectionService.REMOTE_OUTBOUND_CONNECTION_BASE_SERVICE_NAME.append(new String[]{connectionName});
        ServiceName deprecatedName = AbstractOutboundConnectionService.OUTBOUND_CONNECTION_BASE_SERVICE_NAME.append(new String[]{connectionName});
        ServiceBuilder builder = context.getServiceTarget().addService(serviceName);
        Consumer serviceConsumer = builder.provides(new ServiceName[]{deprecatedName, aliasServiceName});
        Supplier osbSupplier = builder.requires(outboundSocketBindingDependency);
        Supplier acSupplier = authenticationContext != null ? builder.requires(context.getCapabilityServiceName("org.wildfly.security.authentication-context", authenticationContext, AuthenticationContext.class)) : null;
        builder.requires(RemotingServices.SUBSYSTEM_ENDPOINT);
        builder.setInstance((Service)new RemoteOutboundConnectionService(serviceConsumer, osbSupplier, acSupplier, connOpts, username, protocol));
        builder.install();
    }
}

