/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.extension;

import io.smallrye.reactive.messaging.EmitterConfiguration;
import io.smallrye.reactive.messaging.EmitterFactory;
import io.smallrye.reactive.messaging.EmitterType;
import io.smallrye.reactive.messaging.annotations.Blocking;
import io.smallrye.reactive.messaging.annotations.Broadcast;
import io.smallrye.reactive.messaging.annotations.EmitterFactoryFor;
import io.smallrye.reactive.messaging.annotations.Incomings;
import io.smallrye.reactive.messaging.providers.DefaultEmitterConfiguration;
import io.smallrye.reactive.messaging.providers.connectors.WorkerPoolRegistry;
import io.smallrye.reactive.messaging.providers.extension.ChannelConfiguration;
import io.smallrye.reactive.messaging.providers.extension.ChannelProducer;
import io.smallrye.reactive.messaging.providers.extension.HealthCenter;
import io.smallrye.reactive.messaging.providers.extension.MediatorManager;
import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.providers.i18n.ProviderLogging;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.OnOverflow;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.reactivestreams.Publisher;

public class ReactiveMessagingExtension
implements Extension {
    private final List<MediatorBean<?>> mediatorBeans = new ArrayList();
    private final List<InjectionPoint> streamInjectionPoints = new ArrayList<InjectionPoint>();
    private final Map<InjectionPoint, EmitterFactoryFor> emitterInjectionPoints = new HashMap<InjectionPoint, EmitterFactoryFor>();
    private final List<EmitterFactoryBean<?>> emitterFactoryBeans = new ArrayList();
    private final List<WorkerPoolBean<?>> workerPoolBeans = new ArrayList();
    @Inject
    HealthCenter health;

    <T> void processClassesContainingMediators(@Observes ProcessManagedBean<T> event) {
        AnnotatedType annotatedType = event.getAnnotatedBeanClass();
        if (annotatedType.getMethods().stream().anyMatch(m -> m.isAnnotationPresent(Incomings.class) || m.isAnnotationPresent(Incoming.class) || m.isAnnotationPresent(Outgoing.class))) {
            this.mediatorBeans.add(new MediatorBean(event.getBean(), event.getAnnotatedBeanClass()));
        }
    }

    <T extends EmitterFactory<?>> void processEmitterFactories(@Observes @WithAnnotations(value={EmitterFactoryFor.class}) ProcessAnnotatedType<T> event) {
        AnnotatedType annotatedType = event.getAnnotatedType();
        this.emitterFactoryBeans.add(new EmitterFactoryBean(annotatedType));
    }

    <T> void processBlockingAnnotation(@Observes @WithAnnotations(value={Blocking.class}) ProcessAnnotatedType<T> event) {
        AnnotatedType annotatedType = event.getAnnotatedType();
        this.workerPoolBeans.add(new WorkerPoolBean(annotatedType));
    }

    <T extends Publisher<?>> void processStreamPublisherInjectionPoint(@Observes ProcessInjectionPoint<?, T> pip) {
        Channel stream = ChannelProducer.getChannelQualifier(pip.getInjectionPoint());
        if (stream != null) {
            this.streamInjectionPoints.add(pip.getInjectionPoint());
        }
    }

    void processStreamSpecEmitterInjectionPoint(@Observes ProcessInjectionPoint<?, Emitter<?>> pip) {
        EmitterFactoryFor emitterType;
        Channel stream = ChannelProducer.getChannelQualifier(pip.getInjectionPoint());
        if (stream != null && (emitterType = this.emitterType(pip.getInjectionPoint(), this.emitterFactoryBeans)) != null) {
            this.emitterInjectionPoints.put(pip.getInjectionPoint(), emitterType);
        }
    }

    <T extends EmitterType> void processStreamEmitterInjectionPoint(@Observes ProcessInjectionPoint<?, T> pip) {
        EmitterFactoryFor emitterType;
        Channel stream = ChannelProducer.getChannelQualifier(pip.getInjectionPoint());
        if (stream != null && (emitterType = this.emitterType(pip.getInjectionPoint(), this.emitterFactoryBeans)) != null) {
            this.emitterInjectionPoints.put(pip.getInjectionPoint(), emitterType);
        }
    }

    <T extends PublisherBuilder<?>> void processStreamPublisherBuilderInjectionPoint(@Observes ProcessInjectionPoint<?, T> pip) {
        Channel stream = ChannelProducer.getChannelQualifier(pip.getInjectionPoint());
        if (stream != null) {
            this.streamInjectionPoints.add(pip.getInjectionPoint());
        }
    }

    void afterDeploymentValidation(@Observes AfterDeploymentValidation done, BeanManager beanManager) {
        Instance instance = beanManager.createInstance();
        MediatorManager mediatorManager = (MediatorManager)instance.select(MediatorManager.class, new Annotation[0]).get();
        WorkerPoolRegistry workerPoolRegistry = (WorkerPoolRegistry)instance.select(WorkerPoolRegistry.class, new Annotation[0]).get();
        List<EmitterConfiguration> emitters = this.createEmitterConfigurations();
        for (EmitterConfiguration emitter : emitters) {
            mediatorManager.addEmitter(emitter);
        }
        List<ChannelConfiguration> channels = this.createChannelConfigurations();
        for (ChannelConfiguration channelConfiguration : channels) {
            mediatorManager.addChannel(channelConfiguration);
        }
        for (MediatorBean mediatorBean : this.mediatorBeans) {
            ProviderLogging.log.analyzingMediatorBean(mediatorBean.bean);
            mediatorManager.analyze(mediatorBean.annotatedType, mediatorBean.bean);
        }
        for (WorkerPoolBean workerPoolBean : this.workerPoolBeans) {
            workerPoolRegistry.analyzeWorker(workerPoolBean.annotatedType);
        }
        mediatorManager.start();
    }

    private List<ChannelConfiguration> createChannelConfigurations() {
        ArrayList<ChannelConfiguration> channels = new ArrayList<ChannelConfiguration>();
        for (InjectionPoint ip : this.streamInjectionPoints) {
            String name = ChannelProducer.getChannelName(ip);
            channels.add(new ChannelConfiguration(name));
        }
        return channels;
    }

    private List<EmitterConfiguration> createEmitterConfigurations() {
        ArrayList<EmitterConfiguration> emitters = new ArrayList<EmitterConfiguration>();
        this.createEmitterConfiguration(this.emitterInjectionPoints, emitters);
        return emitters;
    }

    private void createEmitterConfiguration(Map<InjectionPoint, EmitterFactoryFor> emitterInjectionPoints, List<EmitterConfiguration> emitters) {
        for (Map.Entry<InjectionPoint, EmitterFactoryFor> entry : emitterInjectionPoints.entrySet()) {
            InjectionPoint point = entry.getKey();
            EmitterFactoryFor emitterType = entry.getValue();
            String name = ChannelProducer.getChannelName(point);
            OnOverflow onOverflow = (OnOverflow)point.getAnnotated().getAnnotation(OnOverflow.class);
            if (onOverflow == null) {
                onOverflow = this.createOnOverflowForLegacyAnnotation(point);
            }
            Broadcast broadcast = (Broadcast)point.getAnnotated().getAnnotation(Broadcast.class);
            emitters.add(new DefaultEmitterConfiguration(name, emitterType, onOverflow, broadcast));
        }
    }

    private OnOverflow createOnOverflowForLegacyAnnotation(InjectionPoint point) {
        final io.smallrye.reactive.messaging.annotations.OnOverflow legacy = (io.smallrye.reactive.messaging.annotations.OnOverflow)point.getAnnotated().getAnnotation(io.smallrye.reactive.messaging.annotations.OnOverflow.class);
        if (legacy != null) {
            return new OnOverflow(){

                public Class<? extends Annotation> annotationType() {
                    return OnOverflow.class;
                }

                public OnOverflow.Strategy value() {
                    return OnOverflow.Strategy.valueOf((String)legacy.value().name());
                }

                public long bufferSize() {
                    return legacy.bufferSize();
                }
            };
        }
        return null;
    }

    private EmitterFactoryFor emitterType(InjectionPoint point, List<EmitterFactoryBean<?>> emitterFactoryBeans) {
        for (EmitterFactoryBean<?> emitterFactoryBean : emitterFactoryBeans) {
            EmitterFactoryFor annotation = (EmitterFactoryFor)emitterFactoryBean.emitterFactoryType.getAnnotation(EmitterFactoryFor.class);
            Type type = point.getType();
            if (type instanceof ParameterizedType && ((ParameterizedType)type).getActualTypeArguments().length > 0) {
                if (!((ParameterizedType)type).getRawType().equals(annotation.value())) continue;
                return annotation;
            }
            throw ProviderExceptions.ex.invalidRawEmitter(point);
        }
        return null;
    }

    static class EmitterFactoryBean<T> {
        final AnnotatedType<T> emitterFactoryType;

        EmitterFactoryBean(AnnotatedType<T> emitterFactoryType) {
            this.emitterFactoryType = emitterFactoryType;
        }
    }

    static class WorkerPoolBean<T> {
        final AnnotatedType<T> annotatedType;

        WorkerPoolBean(AnnotatedType<T> annotatedType) {
            this.annotatedType = annotatedType;
        }
    }

    static class MediatorBean<T> {
        final Bean<T> bean;
        final AnnotatedType<T> annotatedType;

        MediatorBean(Bean<T> bean, AnnotatedType<T> annotatedType) {
            this.bean = bean;
            this.annotatedType = annotatedType;
        }
    }
}

