/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.NetworkUtils;
import org.wildfly.security.http.oidc.Oidc;
import org.wildfly.security.http.oidc.OidcClientConfiguration;
import org.wildfly.security.http.oidc.ServerRequest;

public class NodesRegistrationManagement {
    private final Map<String, NodeRegistrationContext> nodeRegistrations = new ConcurrentHashMap<String, NodeRegistrationContext>();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public void tryRegister(final OidcClientConfiguration resolvedDeployment) {
        String registrationUri;
        if (resolvedDeployment.isRegisterNodeAtStartup() && this.needRefreshRegistration(registrationUri = resolvedDeployment.getRegisterNodeUrl(), resolvedDeployment)) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (NodesRegistrationManagement.this.needRefreshRegistration(registrationUri, resolvedDeployment)) {
                        NodesRegistrationManagement.this.sendRegistrationEvent(resolvedDeployment);
                    }
                }
            };
            this.executor.execute(runnable);
        }
    }

    private boolean needRefreshRegistration(String registrationUri, OidcClientConfiguration resolvedDeployment) {
        NodeRegistrationContext currentRegistration = this.nodeRegistrations.get(registrationUri);
        if (currentRegistration == null) {
            return true;
        }
        return currentRegistration.lastRegistrationTime + resolvedDeployment.getRegisterNodePeriod() < Oidc.getCurrentTimeInSeconds();
    }

    public void stop() {
        this.executor.shutdownNow();
        Collection<NodeRegistrationContext> allRegistrations = this.nodeRegistrations.values();
        for (NodeRegistrationContext registration : allRegistrations) {
            this.sendUnregistrationEvent(registration.resolvedDeployment);
        }
    }

    protected void sendRegistrationEvent(OidcClientConfiguration deployment) {
        String registrationUri = deployment.getRegisterNodeUrl();
        if (!this.needRefreshRegistration(registrationUri, deployment)) {
            return;
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        ElytronMessages.log.debug("Sending registration event right now");
        String host = NodesRegistrationManagement.getHostName();
        try {
            ServerRequest.invokeRegisterNodeForKeycloak(deployment, host);
            NodeRegistrationContext regContext = new NodeRegistrationContext(Oidc.getCurrentTimeInSeconds(), deployment);
            this.nodeRegistrations.put(deployment.getRegisterNodeUrl(), regContext);
            ElytronMessages.log.debugf("Node '%s' successfully registered in Keycloak", host);
        }
        catch (ServerRequest.HttpFailure failure) {
            ElytronMessages.log.error("failed to register node to keycloak");
            ElytronMessages.log.error("status from server: " + failure.getStatus());
            if (failure.getError() != null) {
                ElytronMessages.log.error("   " + failure.getError());
            }
        }
        catch (IOException e) {
            ElytronMessages.log.error("failed to register node to keycloak", e);
        }
    }

    protected boolean sendUnregistrationEvent(OidcClientConfiguration deployment) {
        ElytronMessages.log.debug("Sending Unregistration event right now");
        String host = NodesRegistrationManagement.getHostName();
        try {
            ServerRequest.invokeUnregisterNodeForKeycloak(deployment, host);
            ElytronMessages.log.debugf("Node '%s' successfully unregistered from Keycloak", host);
            return true;
        }
        catch (ServerRequest.HttpFailure failure) {
            ElytronMessages.log.error("failed to unregister node from keycloak");
            ElytronMessages.log.error("status from server: " + failure.getStatus());
            if (failure.getError() != null) {
                ElytronMessages.log.error("   " + failure.getError());
            }
            return false;
        }
        catch (IOException e) {
            ElytronMessages.log.error("failed to unregister node from keycloak", e);
            return false;
        }
    }

    private static String getHostName() {
        return NodesRegistrationManagement.getHostNameImpl().trim().toLowerCase();
    }

    private static String getHostNameImpl() {
        String bindAddr = System.getProperty("jboss.bind.address");
        if (bindAddr != null && !bindAddr.trim().equals("0.0.0.0")) {
            return bindAddr;
        }
        String qualifiedHostName = System.getProperty("jboss.qualified.host.name");
        if (qualifiedHostName != null) {
            return qualifiedHostName;
        }
        qualifiedHostName = System.getenv("HOSTNAME");
        if (qualifiedHostName != null) {
            return qualifiedHostName;
        }
        qualifiedHostName = System.getenv("COMPUTERNAME");
        if (qualifiedHostName != null) {
            return qualifiedHostName;
        }
        try {
            return NetworkUtils.canonize(NodesRegistrationManagement.getLocalHost().getHostName());
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
            return "unknown-host.unknown-domain";
        }
    }

    private static InetAddress getLocalHost() throws UnknownHostException {
        InetAddress addr;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            addr = InetAddress.getByName(null);
        }
        return addr;
    }

    public static class NodeRegistrationContext {
        private final Integer lastRegistrationTime;
        private final OidcClientConfiguration resolvedDeployment;

        public NodeRegistrationContext(Integer lastRegTime, OidcClientConfiguration deployment) {
            this.lastRegistrationTime = lastRegTime;
            this.resolvedDeployment = deployment;
        }
    }
}

