/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.lang.invoke.MethodHandles;
import java.util.function.Supplier;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverRootContext;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.identity.impl.IdentifierMappingImplementor;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.path.impl.PojoPathOrdinals;
import org.hibernate.search.mapper.pojo.model.spi.PojoCaster;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.work.impl.CachingCastingEntitySupplier;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkTypeContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;
import org.hibernate.search.util.common.impl.ToStringTreeAppendable;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class AbstractPojoTypeManager<I, E>
implements AutoCloseable,
ToStringTreeAppendable,
PojoWorkTypeContext<I, E> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final String entityName;
    protected final PojoRawTypeIdentifier<E> typeIdentifier;
    protected final PojoCaster<E> caster;
    private final boolean singleConcreteTypeInEntityHierarchy;
    protected final IdentifierMappingImplementor<I, E> identifierMapping;
    private final PojoPathOrdinals pathOrdinals;
    protected final PojoImplicitReindexingResolver<E> reindexingResolver;

    public AbstractPojoTypeManager(String entityName, PojoRawTypeIdentifier<E> typeIdentifier, PojoCaster<E> caster, boolean singleConcreteTypeInEntityHierarchy, IdentifierMappingImplementor<I, E> identifierMapping, PojoPathOrdinals pathOrdinals, PojoImplicitReindexingResolver<E> reindexingResolver) {
        this.entityName = entityName;
        this.typeIdentifier = typeIdentifier;
        this.caster = caster;
        this.singleConcreteTypeInEntityHierarchy = singleConcreteTypeInEntityHierarchy;
        this.identifierMapping = identifierMapping;
        this.pathOrdinals = pathOrdinals;
        this.reindexingResolver = reindexingResolver;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPojoTypeManager that = (AbstractPojoTypeManager)o;
        return this.typeIdentifier.equals(that.typeIdentifier);
    }

    public int hashCode() {
        return this.typeIdentifier.hashCode();
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "[entityName = " + this.entityName + ", javaType = " + this.typeIdentifier + "]";
    }

    @Override
    public void close() {
        this.reindexingResolver.close();
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("entityName", (Object)this.entityName).attribute("typeIdentifier", this.typeIdentifier).attribute("identifierMapping", this.identifierMapping).attribute("reindexingResolver", this.reindexingResolver);
    }

    @Override
    public final PojoRawTypeIdentifier<E> typeIdentifier() {
        return this.typeIdentifier;
    }

    @Override
    public String entityName() {
        return this.entityName;
    }

    @Override
    public final boolean isSingleConcreteTypeInEntityHierarchy() {
        return this.singleConcreteTypeInEntityHierarchy;
    }

    @Override
    public IdentifierMappingImplementor<I, E> identifierMapping() {
        return this.identifierMapping;
    }

    @Override
    public String toDocumentIdentifier(PojoWorkSessionContext sessionContext, I identifier) {
        return this.identifierMapping.toDocumentIdentifier(identifier, sessionContext.mappingContext());
    }

    @Override
    public PojoPathOrdinals pathOrdinals() {
        return this.pathOrdinals;
    }

    @Override
    public PojoImplicitReindexingResolver<E> reindexingResolver() {
        return this.reindexingResolver;
    }

    @Override
    public E toEntity(Object unproxiedEntity) {
        return this.caster.cast(unproxiedEntity);
    }

    @Override
    public final Supplier<E> toEntitySupplier(PojoWorkSessionContext sessionContext, Object entity) {
        if (entity == null) {
            return null;
        }
        PojoRuntimeIntrospector introspector = sessionContext.runtimeIntrospector();
        return new CachingCastingEntitySupplier<E>(this.caster, introspector, entity);
    }

    @Override
    public final void resolveEntitiesToReindex(PojoReindexingCollector collector, PojoWorkSessionContext sessionContext, Object identifier, Supplier<E> entitySupplier, PojoImplicitReindexingResolverRootContext context) {
        try {
            this.reindexingResolver.resolveEntitiesToReindex(collector, entitySupplier.get(), context);
        }
        catch (RuntimeException e) {
            EntityReferenceFactory<?> entityReferenceFactory = sessionContext.mappingContext().entityReferenceFactory();
            Object entityReference = EntityReferenceFactory.safeCreateEntityReference(entityReferenceFactory, (String)this.entityName, (Object)identifier, e::addSuppressed);
            throw log.errorResolvingEntitiesToReindex(entityReference, e.getMessage(), e);
        }
    }
}

