/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.IndexWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractSingleDocumentIndexingWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.SingleDocumentIndexingWork;

public class IndexWork
extends AbstractSingleDocumentIndexingWork
implements SingleDocumentIndexingWork {
    private IndexWork(Builder builder) {
        super(builder);
    }

    public static class Builder
    extends AbstractSingleDocumentIndexingWork.AbstractBuilder<Builder>
    implements IndexWorkBuilder {
        private final URLEncodedString indexName;
        private final URLEncodedString typeName;
        private final String routingKey;
        private final JsonObject document;

        public static Builder forElasticsearch67AndBelow(String entityTypeName, Object entityIdentifier, URLEncodedString elasticsearchIndexName, URLEncodedString typeName, String documentIdentifier, String routingKey, JsonObject document) {
            return new Builder(entityTypeName, entityIdentifier, elasticsearchIndexName, typeName, documentIdentifier, routingKey, document);
        }

        public static Builder forElasticsearch7AndAbove(String entityTypeName, Object entityIdentifier, URLEncodedString elasticsearchIndexName, String documentIdentifier, String routingKey, JsonObject document) {
            return new Builder(entityTypeName, entityIdentifier, elasticsearchIndexName, null, documentIdentifier, routingKey, document);
        }

        private Builder(String entityTypeName, Object entityIdentifier, URLEncodedString elasticsearchIndexName, URLEncodedString typeName, String documentIdentifier, String routingKey, JsonObject document) {
            super(DefaultElasticsearchRequestSuccessAssessor.INSTANCE, entityTypeName, entityIdentifier, documentIdentifier);
            this.indexName = elasticsearchIndexName;
            this.typeName = typeName;
            this.routingKey = routingKey;
            this.document = document;
        }

        @Override
        protected JsonObject buildBulkableActionMetadata() {
            JsonObject index = new JsonObject();
            index.addProperty("_index", this.indexName.original);
            if (this.typeName != null) {
                index.addProperty("_type", this.typeName.original);
            }
            index.addProperty("_id", this.documentIdentifier);
            if (this.routingKey != null) {
                index.addProperty("routing", this.routingKey);
            }
            JsonObject result = new JsonObject();
            result.add("index", (JsonElement)index);
            return result;
        }

        @Override
        protected JsonObject buildBulkableActionBody() {
            return this.document;
        }

        @Override
        public IndexWork build() {
            return new IndexWork(this);
        }
    }
}

