/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.KeyRingIterator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPMarker;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.util.Iterable;
import org.bouncycastle.util.Longs;
import org.bouncycastle.util.Strings;

public class PGPSecretKeyRingCollection
implements Iterable<PGPSecretKeyRing> {
    private Map<Long, PGPSecretKeyRing> secretRings = new HashMap<Long, PGPSecretKeyRing>();
    private List<Long> order = new ArrayList<Long>();

    private PGPSecretKeyRingCollection(Map<Long, PGPSecretKeyRing> map, List<Long> list) {
        this.secretRings = map;
        this.order = list;
    }

    public PGPSecretKeyRingCollection(byte[] byArray, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        this(new ByteArrayInputStream(byArray), keyFingerPrintCalculator);
    }

    public PGPSecretKeyRingCollection(InputStream inputStream, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        Object object;
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(inputStream, keyFingerPrintCalculator);
        while ((object = pGPObjectFactory.nextObject()) != null) {
            if (object instanceof PGPMarker) continue;
            if (!(object instanceof PGPSecretKeyRing)) {
                throw new PGPException(object.getClass().getName() + " found where PGPSecretKeyRing expected");
            }
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)object;
            Long l = Longs.valueOf((long)pGPSecretKeyRing.getPublicKey().getKeyID());
            this.secretRings.put(l, pGPSecretKeyRing);
            this.order.add(l);
        }
    }

    public PGPSecretKeyRingCollection(Collection<PGPSecretKeyRing> collection) {
        for (PGPSecretKeyRing pGPSecretKeyRing : collection) {
            Long l = Longs.valueOf((long)pGPSecretKeyRing.getPublicKey().getKeyID());
            this.secretRings.put(l, pGPSecretKeyRing);
            this.order.add(l);
        }
    }

    public int size() {
        return this.order.size();
    }

    public Iterator<PGPSecretKeyRing> getKeyRings() {
        return this.secretRings.values().iterator();
    }

    public Iterator<PGPSecretKeyRing> getKeyRings(String string) {
        return this.getKeyRings(string, false, false);
    }

    public Iterator<PGPSecretKeyRing> getKeyRings(String string, boolean bl) {
        return this.getKeyRings(string, bl, false);
    }

    public Iterator<PGPSecretKeyRing> getKeyRings(String string, boolean bl, boolean bl2) {
        Iterator<PGPSecretKeyRing> iterator = this.getKeyRings();
        ArrayList<PGPSecretKeyRing> arrayList = new ArrayList<PGPSecretKeyRing>();
        if (bl2) {
            string = Strings.toLowerCase((String)string);
        }
        while (iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = iterator.next();
            Iterator<String> iterator2 = pGPSecretKeyRing.getSecretKey().getUserIDs();
            while (iterator2.hasNext()) {
                String string2 = iterator2.next();
                if (bl2) {
                    string2 = Strings.toLowerCase((String)string2);
                }
                if (bl) {
                    if (string2.indexOf(string) < 0) continue;
                    arrayList.add(pGPSecretKeyRing);
                    continue;
                }
                if (!string2.equals(string)) continue;
                arrayList.add(pGPSecretKeyRing);
            }
        }
        return arrayList.iterator();
    }

    public PGPSecretKey getSecretKey(long l) {
        Iterator<PGPSecretKeyRing> iterator = this.getKeyRings();
        while (iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = iterator.next();
            PGPSecretKey pGPSecretKey = pGPSecretKeyRing.getSecretKey(l);
            if (pGPSecretKey == null) continue;
            return pGPSecretKey;
        }
        return null;
    }

    public PGPSecretKeyRing getSecretKeyRing(long l) {
        Long l2 = Longs.valueOf((long)l);
        if (this.secretRings.containsKey(l2)) {
            return this.secretRings.get(l2);
        }
        Iterator<PGPSecretKeyRing> iterator = this.getKeyRings();
        while (iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = iterator.next();
            PGPSecretKey pGPSecretKey = pGPSecretKeyRing.getSecretKey(l);
            if (pGPSecretKey == null) continue;
            return pGPSecretKeyRing;
        }
        return null;
    }

    public boolean contains(long l) {
        return this.getSecretKey(l) != null;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        BCPGOutputStream bCPGOutputStream = outputStream instanceof BCPGOutputStream ? (BCPGOutputStream)outputStream : new BCPGOutputStream(outputStream);
        Iterator<Long> iterator = this.order.iterator();
        while (iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = this.secretRings.get(iterator.next());
            pGPSecretKeyRing.encode(bCPGOutputStream);
        }
    }

    public static PGPSecretKeyRingCollection addSecretKeyRing(PGPSecretKeyRingCollection pGPSecretKeyRingCollection, PGPSecretKeyRing pGPSecretKeyRing) {
        Long l = Longs.valueOf((long)pGPSecretKeyRing.getPublicKey().getKeyID());
        if (pGPSecretKeyRingCollection.secretRings.containsKey(l)) {
            throw new IllegalArgumentException("Collection already contains a key with a keyID for the passed in ring.");
        }
        HashMap<Long, PGPSecretKeyRing> hashMap = new HashMap<Long, PGPSecretKeyRing>(pGPSecretKeyRingCollection.secretRings);
        ArrayList<Long> arrayList = new ArrayList<Long>(pGPSecretKeyRingCollection.order);
        hashMap.put(l, pGPSecretKeyRing);
        arrayList.add(l);
        return new PGPSecretKeyRingCollection(hashMap, arrayList);
    }

    public static PGPSecretKeyRingCollection removeSecretKeyRing(PGPSecretKeyRingCollection pGPSecretKeyRingCollection, PGPSecretKeyRing pGPSecretKeyRing) {
        Long l = Longs.valueOf((long)pGPSecretKeyRing.getPublicKey().getKeyID());
        if (!pGPSecretKeyRingCollection.secretRings.containsKey(l)) {
            throw new IllegalArgumentException("Collection does not contain a key with a keyID for the passed in ring.");
        }
        HashMap<Long, PGPSecretKeyRing> hashMap = new HashMap<Long, PGPSecretKeyRing>(pGPSecretKeyRingCollection.secretRings);
        ArrayList<Long> arrayList = new ArrayList<Long>(pGPSecretKeyRingCollection.order);
        hashMap.remove(l);
        for (int i = 0; i < arrayList.size(); ++i) {
            Long l2 = (Long)arrayList.get(i);
            if (l2.longValue() != l.longValue()) continue;
            arrayList.remove(i);
            break;
        }
        return new PGPSecretKeyRingCollection(hashMap, arrayList);
    }

    public Iterator<PGPSecretKeyRing> iterator() {
        return new KeyRingIterator<PGPSecretKeyRing>(this.order, this.secretRings);
    }
}

