/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer.metrics;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.LocalModelControllerClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.micrometer.metrics.MetricMetadata;
import org.wildfly.extension.micrometer.metrics.MetricRegistration;
import org.wildfly.extension.micrometer.metrics.WildFlyMetric;
import org.wildfly.extension.micrometer.metrics.WildFlyMetricMetadata;
import org.wildfly.extension.micrometer.metrics.WildFlyRegistry;

public class MicrometerCollector {
    private final LocalModelControllerClient modelControllerClient;
    private final ProcessStateNotifier processStateNotifier;
    private final WildFlyRegistry micrometerRegistry;

    public MicrometerCollector(LocalModelControllerClient modelControllerClient, ProcessStateNotifier processStateNotifier, WildFlyRegistry micrometerRegistry) {
        this.modelControllerClient = modelControllerClient;
        this.processStateNotifier = processStateNotifier;
        this.micrometerRegistry = micrometerRegistry;
    }

    public synchronized MetricRegistration collectResourceMetrics(Resource resource, ImmutableManagementResourceRegistration managementResourceRegistration, Function<PathAddress, PathAddress> resourceAddressResolver, boolean exposeAnySubsystem, List<String> exposedSubsystems) {
        final MetricRegistration registration = new MetricRegistration(this.micrometerRegistry);
        this.queueMetricRegistration(resource, managementResourceRegistration, PathAddress.EMPTY_ADDRESS, resourceAddressResolver, registration, exposeAnySubsystem, exposedSubsystems);
        this.processStateNotifier.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (ControlledProcessState.State.RUNNING == evt.getNewValue()) {
                    registration.register();
                } else if (ControlledProcessState.State.STOPPING == evt.getNewValue()) {
                    registration.unregister();
                    MicrometerCollector.this.processStateNotifier.removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
        });
        if (ControlledProcessState.State.RUNNING == this.processStateNotifier.getCurrentState()) {
            registration.register();
        }
        return registration;
    }

    private void queueMetricRegistration(Resource current, ImmutableManagementResourceRegistration managementResourceRegistration, PathAddress address, Function<PathAddress, PathAddress> resourceAddressResolver, MetricRegistration registration, boolean exposeAnySubsystem, List<String> exposedSubsystems) {
        if (!this.isExposingMetrics(address, exposeAnySubsystem, exposedSubsystems)) {
            return;
        }
        Map attributes = managementResourceRegistration.getAttributes(address);
        if (attributes == null) {
            return;
        }
        ModelNode resourceDescription = null;
        for (Map.Entry entry : attributes.entrySet()) {
            AttributeAccess attributeAccess = (AttributeAccess)entry.getValue();
            if (!this.isCollectibleMetric(attributeAccess)) continue;
            if (resourceDescription == null) {
                DescriptionProvider modelDescription = managementResourceRegistration.getModelDescription(address);
                resourceDescription = modelDescription.getModelDescription(Locale.getDefault());
            }
            PathAddress resourceAddress = resourceAddressResolver.apply(address);
            String attributeName = (String)entry.getKey();
            MeasurementUnit unit = attributeAccess.getAttributeDefinition().getMeasurementUnit();
            boolean isCounter = attributeAccess.getFlags().contains(AttributeAccess.Flag.COUNTER_METRIC);
            String attributeDescription = resourceDescription.get(new String[]{"attributes", attributeName, "description"}).asStringOrNull();
            WildFlyMetric metric = new WildFlyMetric(this.modelControllerClient, resourceAddress, attributeName);
            WildFlyMetricMetadata metadata = new WildFlyMetricMetadata(attributeName, resourceAddress, attributeDescription, unit, isCounter ? MetricMetadata.Type.COUNTER : MetricMetadata.Type.GAUGE);
            registration.addRegistrationTask(() -> registration.registerMetric(metric, metadata));
        }
        for (String type : current.getChildTypes()) {
            for (Resource.ResourceEntry entry : current.getChildren(type)) {
                PathElement pathElement = entry.getPathElement();
                PathAddress childAddress = address.append(new PathElement[]{pathElement});
                this.queueMetricRegistration((Resource)entry, managementResourceRegistration, childAddress, resourceAddressResolver, registration, exposeAnySubsystem, exposedSubsystems);
            }
        }
    }

    private boolean isExposingMetrics(PathAddress address, boolean exposeAnySubsystem, List<String> exposedSubsystems) {
        if (address.size() == 0) {
            return true;
        }
        String subsystemName = this.getSubsystemName(address);
        if (subsystemName != null) {
            return exposeAnySubsystem || exposedSubsystems.contains(subsystemName);
        }
        return false;
    }

    private String getSubsystemName(PathAddress address) {
        if (address.size() == 0) {
            return null;
        }
        if (address.getElement(0).getKey().equals("subsystem")) {
            return address.getElement(0).getValue();
        }
        return this.getSubsystemName(address.subAddress(1));
    }

    private boolean isCollectibleMetric(AttributeAccess attributeAccess) {
        if (attributeAccess.getAccessType() == AttributeAccess.AccessType.METRIC && attributeAccess.getStorageType() == AttributeAccess.Storage.RUNTIME) {
            ModelType type = attributeAccess.getAttributeDefinition().getType();
            return type == ModelType.INT || type == ModelType.LONG || type == ModelType.DOUBLE;
        }
        return false;
    }
}

