/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.opentelemetry;

import io.smallrye.opentelemetry.api.OpenTelemetryConfig;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.opentelemetry.OpenTelemetryDependencyProcessor;
import org.wildfly.extension.opentelemetry.OpenTelemetryDeploymentProcessor;
import org.wildfly.extension.opentelemetry.OpenTelemetrySubsystemDefinition;
import org.wildfly.extension.opentelemetry.api.WildFlyOpenTelemetryConfig;

class OpenTelemetrySubsystemAdd
extends AbstractBoottimeAddStepHandler {
    OpenTelemetrySubsystemAdd() {
        super(OpenTelemetrySubsystemDefinition.ATTRIBUTES);
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        super.performBoottime(context, operation, model);
        final WildFlyOpenTelemetryConfig config = new WildFlyOpenTelemetryConfig(OpenTelemetrySubsystemDefinition.SERVICE_NAME.resolveModelAttribute(context, model).asStringOrNull(), OpenTelemetrySubsystemDefinition.EXPORTER.resolveModelAttribute(context, model).asString(), OpenTelemetrySubsystemDefinition.ENDPOINT.resolveModelAttribute(context, model).asStringOrNull(), OpenTelemetrySubsystemDefinition.BATCH_DELAY.resolveModelAttribute(context, model).asLongOrNull(), OpenTelemetrySubsystemDefinition.MAX_QUEUE_SIZE.resolveModelAttribute(context, model).asLongOrNull(), OpenTelemetrySubsystemDefinition.MAX_EXPORT_BATCH_SIZE.resolveModelAttribute(context, model).asLongOrNull(), OpenTelemetrySubsystemDefinition.EXPORT_TIMEOUT.resolveModelAttribute(context, model).asLongOrNull(), OpenTelemetrySubsystemDefinition.SAMPLER.resolveModelAttribute(context, model).asStringOrNull(), OpenTelemetrySubsystemDefinition.RATIO.resolveModelAttribute(context, model).asDoubleOrNull());
        OpenTelemetrySubsystemDefinition.CONFIG_SUPPLIER.accept((OpenTelemetryConfig)config);
        final boolean mpTelemetryInstalled = context.getCapabilityServiceSupport().hasCapability("org.wildfly.extension.microprofile.telemetry");
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("opentelemetry", Phase.DEPENDENCIES, 6416, (DeploymentUnitProcessor)new OpenTelemetryDependencyProcessor());
                processorTarget.addDeploymentProcessor("opentelemetry", Phase.POST_MODULE, 14352, (DeploymentUnitProcessor)new OpenTelemetryDeploymentProcessor(!mpTelemetryInstalled, config));
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

