/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.builder;

import jakarta.enterprise.inject.spi.Annotated;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.logging.UtilLogger;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.util.ApiAbstraction;

public class InterceptorsApiAbstraction
extends ApiAbstraction
implements Service {
    private final Class<? extends Annotation> INTERCEPTORS_ANNOTATION_CLASS = this.annotationTypeForName("jakarta.interceptor.Interceptors");
    private final Method interceptorsValueMethod;
    private final Class<? extends Annotation> EXCLUDE_CLASS_INTERCEPTORS_ANNOTATION_CLASS = this.annotationTypeForName("jakarta.interceptor.ExcludeClassInterceptors");

    public InterceptorsApiAbstraction(ResourceLoader resourceLoader) {
        super(resourceLoader);
        if (ApiAbstraction.DummyAnnotation.class.isAssignableFrom(this.INTERCEPTORS_ANNOTATION_CLASS)) {
            this.interceptorsValueMethod = null;
        } else {
            try {
                this.interceptorsValueMethod = this.INTERCEPTORS_ANNOTATION_CLASS.getMethod("value", new Class[0]);
            }
            catch (Exception e) {
                throw UtilLogger.LOG.annotationValuesInaccessible(e);
            }
        }
    }

    public Class<? extends Annotation> getInterceptorsAnnotationClass() {
        return this.INTERCEPTORS_ANNOTATION_CLASS;
    }

    public Class<? extends Annotation> getExcludeClassInterceptorsAnnotationClass() {
        return this.EXCLUDE_CLASS_INTERCEPTORS_ANNOTATION_CLASS;
    }

    public Class<?>[] extractInterceptorClasses(Annotated annotated) {
        Annotation annotation = annotated.getAnnotation(this.INTERCEPTORS_ANNOTATION_CLASS);
        if (annotation != null) {
            try {
                return (Class[])this.interceptorsValueMethod.invoke((Object)annotation, new Object[0]);
            }
            catch (Exception e) {
                throw UtilLogger.LOG.annotationValuesInaccessible(e);
            }
        }
        return null;
    }

    public void cleanup() {
    }
}

