/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.util.List;
import java.util.function.Supplier;
import org.hibernate.CacheMode;
import org.hibernate.LockOptions;
import org.hibernate.MultiIdentifierLoadAccess;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.SessionImpl;
import org.hibernate.loader.ast.spi.MultiIdLoadOptions;
import org.hibernate.persister.entity.EntityPersister;

class MultiIdentifierLoadAccessImpl<T>
implements MultiIdentifierLoadAccess<T>,
MultiIdLoadOptions {
    private final SessionImpl session;
    private final EntityPersister entityPersister;
    private LockOptions lockOptions;
    private CacheMode cacheMode;
    private RootGraphImplementor<T> rootGraph;
    private GraphSemantic graphSemantic;
    private Integer batchSize;
    private boolean sessionCheckingEnabled;
    private boolean returnOfDeletedEntitiesEnabled;
    private boolean orderedReturnEnabled = true;

    public MultiIdentifierLoadAccessImpl(SessionImpl session, EntityPersister entityPersister) {
        this.session = session;
        this.entityPersister = entityPersister;
    }

    @Override
    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    @Override
    public final MultiIdentifierLoadAccess<T> with(LockOptions lockOptions) {
        this.lockOptions = lockOptions;
        return this;
    }

    @Override
    public MultiIdentifierLoadAccess<T> with(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    @Override
    public MultiIdentifierLoadAccess<T> with(RootGraph<T> graph, GraphSemantic semantic) {
        this.rootGraph = (RootGraphImplementor)graph;
        this.graphSemantic = semantic;
        return this;
    }

    @Override
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @Override
    public MultiIdentifierLoadAccess<T> withBatchSize(int batchSize) {
        this.batchSize = batchSize < 1 ? null : Integer.valueOf(batchSize);
        return this;
    }

    @Override
    public boolean isSessionCheckingEnabled() {
        return this.sessionCheckingEnabled;
    }

    @Override
    public boolean isSecondLevelCacheCheckingEnabled() {
        return this.cacheMode == CacheMode.NORMAL || this.cacheMode == CacheMode.GET;
    }

    @Override
    public MultiIdentifierLoadAccess<T> enableSessionCheck(boolean enabled) {
        this.sessionCheckingEnabled = enabled;
        return this;
    }

    @Override
    public boolean isReturnOfDeletedEntitiesEnabled() {
        return this.returnOfDeletedEntitiesEnabled;
    }

    @Override
    public MultiIdentifierLoadAccess<T> enableReturnOfDeletedEntities(boolean enabled) {
        this.returnOfDeletedEntitiesEnabled = enabled;
        return this;
    }

    @Override
    public boolean isOrderReturnEnabled() {
        return this.orderedReturnEnabled;
    }

    @Override
    public MultiIdentifierLoadAccess<T> enableOrderedReturn(boolean enabled) {
        this.orderedReturnEnabled = enabled;
        return this;
    }

    @Override
    public <K> List<T> multiLoad(K ... ids) {
        return this.perform(() -> this.entityPersister.multiLoad(ids, this.session, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> perform(Supplier<List<T>> executor) {
        CacheMode sessionCacheMode = this.session.getCacheMode();
        boolean cacheModeChanged = false;
        if (this.cacheMode != null && this.cacheMode != sessionCacheMode) {
            this.session.setCacheMode(this.cacheMode);
            cacheModeChanged = true;
        }
        try {
            if (this.graphSemantic != null) {
                if (this.rootGraph == null) {
                    throw new IllegalArgumentException("Graph semantic specified, but no RootGraph was supplied");
                }
                this.session.getLoadQueryInfluencers().getEffectiveEntityGraph().applyGraph(this.rootGraph, this.graphSemantic);
            }
            try {
                List<T> list = executor.get();
                if (this.graphSemantic != null) {
                    this.session.getLoadQueryInfluencers().getEffectiveEntityGraph().clear();
                }
                return list;
            }
            catch (Throwable throwable) {
                if (this.graphSemantic != null) {
                    this.session.getLoadQueryInfluencers().getEffectiveEntityGraph().clear();
                }
                throw throwable;
            }
        }
        finally {
            if (cacheModeChanged) {
                this.session.setCacheMode(sessionCacheMode);
            }
        }
    }

    @Override
    public <K> List<T> multiLoad(List<K> ids) {
        return this.perform(() -> this.entityPersister.multiLoad(ids.toArray(new Object[0]), this.session, this));
    }
}

