/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.ast.internal.CollectionBatchLoaderArrayParam;
import org.hibernate.loader.ast.internal.CollectionBatchLoaderInPredicate;
import org.hibernate.loader.ast.internal.EntityBatchLoaderArrayParam;
import org.hibernate.loader.ast.internal.EntityBatchLoaderInPredicate;
import org.hibernate.loader.ast.internal.MultiKeyLoadHelper;
import org.hibernate.loader.ast.spi.BatchLoaderFactory;
import org.hibernate.loader.ast.spi.CollectionBatchLoader;
import org.hibernate.loader.ast.spi.EntityBatchLoader;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;

public class StandardBatchLoaderFactory
implements BatchLoaderFactory {
    public StandardBatchLoaderFactory(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
    }

    @Override
    public <T> EntityBatchLoader<T> createEntityBatchLoader(int domainBatchSize, EntityMappingType entityDescriptor, SessionFactoryImplementor factory) {
        Dialect dialect = factory.getJdbcServices().getDialect();
        Type identifierType = entityDescriptor.getEntityPersister().getIdentifierType();
        int idColumnCount = identifierType.getColumnSpan(factory);
        if (idColumnCount == 1 && MultiKeyLoadHelper.supportsSqlArrayType(dialect) && identifierType instanceof BasicType) {
            return new EntityBatchLoaderArrayParam(domainBatchSize, entityDescriptor, factory);
        }
        int optimalBatchSize = dialect.getBatchLoadSizingStrategy().determineOptimalBatchLoadSize(idColumnCount, domainBatchSize, false);
        return new EntityBatchLoaderInPredicate(domainBatchSize, optimalBatchSize, entityDescriptor, factory);
    }

    @Override
    public CollectionBatchLoader createCollectionBatchLoader(int domainBatchSize, LoadQueryInfluencers influencers, PluralAttributeMapping attributeMapping, SessionFactoryImplementor factory) {
        Dialect dialect = factory.getJdbcServices().getDialect();
        int columnCount = attributeMapping.getKeyDescriptor().getJdbcTypeCount();
        if (columnCount == 1 && dialect.supportsStandardArrays() && dialect.getPreferredSqlTypeCodeForArray() == 2003) {
            return new CollectionBatchLoaderArrayParam(domainBatchSize, influencers, attributeMapping, factory);
        }
        return new CollectionBatchLoaderInPredicate(domainBatchSize, influencers, attributeMapping, factory);
    }
}

