/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.QueryException;
import org.hibernate.engine.query.ParameterRecognitionException;
import org.hibernate.query.internal.QueryParameterNamedImpl;
import org.hibernate.query.internal.QueryParameterPositionalImpl;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sql.spi.ParameterOccurrence;
import org.hibernate.query.sql.spi.ParameterRecognizer;

public class ParameterRecognizerImpl
implements ParameterRecognizer {
    private ParameterStyle parameterStyle;
    private Map<String, QueryParameterImplementor<?>> namedQueryParameters;
    private Map<Integer, QueryParameterImplementor<?>> positionalQueryParameters;
    private int ordinalParameterImplicitPosition = 1;
    private List<ParameterOccurrence> parameterList;
    private final StringBuilder sqlStringBuffer = new StringBuilder();

    @Override
    public void complete() {
        if (this.positionalQueryParameters != null) {
            int[] positionsArray = this.positionalQueryParameters.keySet().stream().mapToInt(Integer::intValue).toArray();
            Arrays.sort(positionsArray);
            int previous = 0;
            boolean first = true;
            int[] nArray = positionsArray;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer position = nArray[i];
                if (position != previous + 1) {
                    if (first) {
                        throw new QueryException("Ordinal parameters did not start with base 1 : " + position);
                    }
                    throw new QueryException("Gap in ordinal parameter positions; skipped " + (previous + 1));
                }
                first = false;
                previous = position;
            }
        }
    }

    public Map<String, QueryParameterImplementor<?>> getNamedQueryParameters() {
        return this.namedQueryParameters;
    }

    public Map<Integer, QueryParameterImplementor<?>> getPositionalQueryParameters() {
        return this.positionalQueryParameters;
    }

    public List<ParameterOccurrence> getParameterList() {
        return this.parameterList;
    }

    public String getAdjustedSqlString() {
        return this.sqlStringBuffer.toString();
    }

    @Override
    public void ordinalParameter(int sourcePosition) {
        if (this.parameterStyle == null) {
            this.parameterStyle = ParameterStyle.JDBC;
        } else if (this.parameterStyle != ParameterStyle.JDBC) {
            throw new IllegalStateException("Cannot mix parameter styles between JDBC-style, ordinal and named in the same query");
        }
        int implicitPosition = this.ordinalParameterImplicitPosition++;
        QueryParameterImplementor<?> parameter = null;
        if (this.positionalQueryParameters == null) {
            this.positionalQueryParameters = new HashMap();
        } else {
            parameter = this.positionalQueryParameters.get(implicitPosition);
        }
        if (parameter == null) {
            parameter = QueryParameterPositionalImpl.fromNativeQuery(implicitPosition);
            this.positionalQueryParameters.put(implicitPosition, parameter);
        }
        if (this.parameterList == null) {
            this.parameterList = new ArrayList<ParameterOccurrence>();
        }
        this.parameterList.add(new ParameterOccurrence(parameter, this.sqlStringBuffer.length()));
        this.sqlStringBuffer.append("?");
    }

    @Override
    public void namedParameter(String name, int sourcePosition) {
        if (this.parameterStyle == null) {
            this.parameterStyle = ParameterStyle.NAMED;
        } else if (this.parameterStyle != ParameterStyle.NAMED) {
            throw new ParameterRecognitionException("Cannot mix parameter styles between JDBC-style, ordinal and named in the same query");
        }
        QueryParameterImplementor<?> parameter = null;
        if (this.namedQueryParameters == null) {
            this.namedQueryParameters = new HashMap();
        } else {
            parameter = this.namedQueryParameters.get(name);
        }
        if (parameter == null) {
            parameter = QueryParameterNamedImpl.fromNativeQuery(name);
            this.namedQueryParameters.put(name, parameter);
        }
        if (this.parameterList == null) {
            this.parameterList = new ArrayList<ParameterOccurrence>();
        }
        this.parameterList.add(new ParameterOccurrence(parameter, this.sqlStringBuffer.length()));
        this.sqlStringBuffer.append("?");
    }

    @Override
    public void jpaPositionalParameter(int position, int sourcePosition) {
        if (this.parameterStyle == null) {
            this.parameterStyle = ParameterStyle.NAMED;
        } else if (this.parameterStyle != ParameterStyle.NAMED) {
            throw new IllegalStateException("Cannot mix parameter styles between JDBC-style, ordinal and named in the same query");
        }
        if (position < 1) {
            throw new QueryException("Incoming parameter position [" + position + "] is less than base [1]");
        }
        QueryParameterImplementor<?> parameter = null;
        if (this.positionalQueryParameters == null) {
            this.positionalQueryParameters = new HashMap();
        } else {
            parameter = this.positionalQueryParameters.get(position);
        }
        if (parameter == null) {
            parameter = QueryParameterPositionalImpl.fromNativeQuery(position);
            this.positionalQueryParameters.put(position, parameter);
        }
        if (this.parameterList == null) {
            this.parameterList = new ArrayList<ParameterOccurrence>();
        }
        this.parameterList.add(new ParameterOccurrence(parameter, this.sqlStringBuffer.length()));
        this.sqlStringBuffer.append("?");
    }

    @Override
    public void other(char character) {
        this.sqlStringBuffer.append(character);
    }

    private static enum ParameterStyle {
        JDBC,
        ORDINAL,
        NAMED;

    }
}

