/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import java.io.IOException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Predicate;
import org.wildfly.clustering.ejb.infinispan.timer.TimerAccessMetaData;
import org.wildfly.clustering.ejb.infinispan.timer.TimerCreationMetaData;
import org.wildfly.clustering.ejb.infinispan.timer.TimerMetaDataConfiguration;
import org.wildfly.clustering.ejb.timer.ImmutableTimerMetaData;
import org.wildfly.clustering.ejb.timer.TimerConfiguration;
import org.wildfly.clustering.ejb.timer.TimerType;
import org.wildfly.clustering.marshalling.spi.Marshaller;

public class CompositeImmutableTimerMetaData<V>
implements ImmutableTimerMetaData {
    private final TimerCreationMetaData<V> creationMetaData;
    private final TimerAccessMetaData accessMetaData;
    private final Marshaller<Object, V> marshaller;
    private final boolean persistent;

    public CompositeImmutableTimerMetaData(TimerMetaDataConfiguration<V> configuration, TimerCreationMetaData<V> creationMetaData, TimerAccessMetaData accessMetaData) {
        this.marshaller = configuration.getMarshaller();
        this.creationMetaData = creationMetaData;
        this.accessMetaData = accessMetaData;
        this.persistent = configuration.isPersistent();
    }

    public TimerType getType() {
        return this.creationMetaData.getType();
    }

    public Object getContext() {
        try {
            return this.marshaller.read(this.creationMetaData.getContext());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public Instant getLastTimout() {
        Duration lastTimeout = this.accessMetaData.getLastTimout();
        return lastTimeout != null ? this.creationMetaData.getStart().plus(lastTimeout) : null;
    }

    public Instant getNextTimeout() {
        return (Instant)this.creationMetaData.apply(this.getLastTimout());
    }

    public <TC extends TimerConfiguration> TC getConfiguration(Class<TC> configurationClass) {
        return (TC)((TimerConfiguration)configurationClass.cast(this.creationMetaData));
    }

    public Predicate<Method> getTimeoutMatcher() {
        return this.creationMetaData.getTimeoutMatcher();
    }
}

