/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.el.cache;

import jakarta.el.ELException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BeanPropertiesCache {
    private static final SoftConcurrentHashMap properties = new SoftConcurrentHashMap();

    public static Method getMethod(Class<?> type, Object base, Method m) {
        if (m == null || Modifier.isPublic(type.getModifiers()) && (BeanPropertiesCache.canAccess(base, m) || base != null && BeanPropertiesCache.canAccess(null, m))) {
            return m;
        }
        Class<?>[] inf = type.getInterfaces();
        Method mp = null;
        for (int i = 0; i < inf.length; ++i) {
            try {
                mp = inf[i].getMethod(m.getName(), m.getParameterTypes());
                mp = BeanPropertiesCache.getMethod(mp.getDeclaringClass(), base, mp);
                if (mp == null) continue;
                return mp;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        Class<?> sup = type.getSuperclass();
        if (sup != null) {
            try {
                mp = sup.getMethod(m.getName(), m.getParameterTypes());
                mp = BeanPropertiesCache.getMethod(mp.getDeclaringClass(), base, mp);
                if (mp != null) {
                    return mp;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    static boolean canAccess(Object base, AccessibleObject accessibleObject) {
        try {
            return accessibleObject.canAccess(base);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    public static Map<Class<?>, BeanProperties> getProperties() {
        return properties;
    }

    static void clear(ClassLoader classLoader) {
        properties.clear(classLoader);
    }

    public static final class BeanProperties {
        private final Map<String, BeanProperty> propertyMap = new HashMap<String, BeanProperty>();

        public BeanProperties(Class<?> baseClass) {
            try {
                PropertyDescriptor[] descriptors;
                BeanInfo info = Introspector.getBeanInfo(baseClass);
                for (PropertyDescriptor descriptor : descriptors = info.getPropertyDescriptors()) {
                    this.propertyMap.put(descriptor.getName(), new BeanProperty(baseClass, descriptor));
                }
                this.populateFromInterfaces(baseClass, baseClass);
            }
            catch (IntrospectionException ie) {
                throw new ELException(ie);
            }
        }

        private void populateFromInterfaces(Class<?> baseClass, Class<?> aClass) throws IntrospectionException {
            Class<?> superclass;
            Class<?>[] interfaces = aClass.getInterfaces();
            if (interfaces.length > 0) {
                for (Class<?> ifs : interfaces) {
                    PropertyDescriptor[] pds;
                    BeanInfo info = Introspector.getBeanInfo(ifs);
                    for (PropertyDescriptor pd : pds = info.getPropertyDescriptors()) {
                        if (this.propertyMap.containsKey(pd.getName())) continue;
                        this.propertyMap.put(pd.getName(), new BeanProperty(baseClass, pd));
                    }
                }
            }
            if ((superclass = aClass.getSuperclass()) != null) {
                this.populateFromInterfaces(baseClass, superclass);
            }
        }

        public BeanProperty getBeanProperty(String property) {
            return this.propertyMap.get(property);
        }
    }

    public static final class BeanProperty {
        private final Class<?> baseClass;
        private final PropertyDescriptor descriptor;
        private Method readMethod;
        private Method writeMethod;

        public BeanProperty(Class<?> baseClass, PropertyDescriptor descriptor) {
            this.baseClass = baseClass;
            this.descriptor = descriptor;
        }

        public Class getPropertyType() {
            return this.descriptor.getPropertyType();
        }

        public boolean isReadOnly(Object base) {
            return this.getWriteMethod(base) == null;
        }

        public Method getReadMethod(Object base) {
            if (this.readMethod == null) {
                this.readMethod = BeanPropertiesCache.getMethod(this.baseClass, base, this.descriptor.getReadMethod());
            }
            return this.readMethod;
        }

        public Method getWriteMethod(Object base) {
            if (this.writeMethod == null) {
                this.writeMethod = BeanPropertiesCache.getMethod(this.baseClass, base, this.descriptor.getWriteMethod());
            }
            return this.writeMethod;
        }
    }

    private static class SoftConcurrentHashMap
    extends ConcurrentHashMap<Class<?>, BeanProperties> {
        private static final long serialVersionUID = -178867497897782229L;
        private static final int CACHE_INIT_SIZE = 1024;
        private ConcurrentHashMap<Class<?>, BPSoftReference> map = new ConcurrentHashMap(1024);
        private ReferenceQueue<BeanProperties> refQ = new ReferenceQueue();

        private SoftConcurrentHashMap() {
        }

        private void cleanup() {
            BPSoftReference BPRef = null;
            while ((BPRef = (BPSoftReference)this.refQ.poll()) != null) {
                this.map.remove(BPRef.key);
            }
        }

        protected void clear(ClassLoader classLoader) {
            Iterator<Map.Entry<Class<?>, BPSoftReference>> it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Class<?>, BPSoftReference> entry = it.next();
                if (entry.getKey().getClassLoader() != classLoader) continue;
                it.remove();
            }
        }

        @Override
        public BeanProperties put(Class<?> key, BeanProperties value) {
            this.cleanup();
            BPSoftReference prev = this.map.put(key, new BPSoftReference(key, value, this.refQ));
            return prev == null ? null : (BeanProperties)prev.get();
        }

        @Override
        public BeanProperties putIfAbsent(Class<?> key, BeanProperties value) {
            this.cleanup();
            BPSoftReference prev = this.map.putIfAbsent(key, new BPSoftReference(key, value, this.refQ));
            return prev == null ? null : (BeanProperties)prev.get();
        }

        @Override
        public BeanProperties get(Object key) {
            this.cleanup();
            BPSoftReference BPRef = this.map.get(key);
            if (BPRef == null) {
                return null;
            }
            if (BPRef.get() == null) {
                this.map.remove(key);
                return null;
            }
            return (BeanProperties)BPRef.get();
        }
    }

    private static class BPSoftReference
    extends SoftReference<BeanProperties> {
        final Class<?> key;

        BPSoftReference(Class<?> key, BeanProperties beanProperties, ReferenceQueue<BeanProperties> refQ) {
            super(beanProperties, refQ);
            this.key = key;
        }
    }
}

