/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterProvider;

public class ExporterMetrics {
    private static final AttributeKey<String> ATTRIBUTE_KEY_TYPE = AttributeKey.stringKey((String)"type");
    private static final AttributeKey<Boolean> ATTRIBUTE_KEY_SUCCESS = AttributeKey.booleanKey((String)"success");
    private final LongCounter seen;
    private final LongCounter exported;
    private final Attributes seenAttrs;
    private final Attributes successAttrs;
    private final Attributes failedAttrs;

    private ExporterMetrics(MeterProvider meterProvider, String exporterName, String type, String transportName) {
        Meter meter = meterProvider.get("io.opentelemetry.exporters." + exporterName + "-" + transportName);
        this.seenAttrs = Attributes.builder().put(ATTRIBUTE_KEY_TYPE, (Object)type).build();
        this.seen = meter.counterBuilder(exporterName + ".exporter.seen").build();
        this.exported = meter.counterBuilder(exporterName + ".exporter.exported").build();
        this.successAttrs = this.seenAttrs.toBuilder().put(ATTRIBUTE_KEY_SUCCESS, (Object)true).build();
        this.failedAttrs = this.seenAttrs.toBuilder().put(ATTRIBUTE_KEY_SUCCESS, (Object)false).build();
    }

    public void addSeen(long value) {
        this.seen.add(value, this.seenAttrs);
    }

    public void addSuccess(long value) {
        this.exported.add(value, this.successAttrs);
    }

    public void addFailed(long value) {
        this.exported.add(value, this.failedAttrs);
    }

    public static ExporterMetrics createGrpc(String exporterName, String type, MeterProvider meterProvider) {
        return new ExporterMetrics(meterProvider, exporterName, type, "grpc");
    }

    public static ExporterMetrics createGrpcOkHttp(String exporterName, String type, MeterProvider meterProvider) {
        return new ExporterMetrics(meterProvider, exporterName, type, "grpc-okhttp");
    }

    public static ExporterMetrics createHttpProtobuf(String exporterName, String type, MeterProvider meterProvider) {
        return new ExporterMetrics(meterProvider, exporterName, type, "http");
    }

    public static ExporterMetrics createHttpJson(String exporterName, String type, MeterProvider meterProvider) {
        return new ExporterMetrics(meterProvider, exporterName, type, "http-json");
    }
}

