/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Collection;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public abstract class RestartParentWriteAttributeHandler
extends AbstractWriteAttributeHandler<ModelNode> {
    private final String parentKeyName;

    public RestartParentWriteAttributeHandler(String parentKeyName, AttributeDefinition ... definitions) {
        super(definitions);
        this.parentKeyName = parentKeyName;
    }

    public RestartParentWriteAttributeHandler(String parentKeyName, Collection<AttributeDefinition> definitions) {
        super(definitions);
        this.parentKeyName = parentKeyName;
    }

    @Override
    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<ModelNode> handbackHolder) throws OperationFailedException {
        ModelNode parentModel;
        ServiceController service;
        PathAddress address = this.getParentAddress(context.getCurrentAddress());
        final ServiceName serviceName = this.getParentServiceName(address);
        ServiceController serviceController = service = serviceName != null ? context.getServiceRegistry(false).getService(serviceName) : null;
        if (service == null) {
            return false;
        }
        boolean restartServices = this.isResourceServiceRestartAllowed(context, service);
        if (restartServices && (parentModel = this.getModel(context, address)) != null && context.markResourceRestarted(address, this)) {
            context.addStep(Util.getReadResourceOperation(address), new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    RestartParentWriteAttributeHandler.this.removeServices(context, serviceName, parentModel);
                    RestartParentWriteAttributeHandler.this.recreateParentService(context, parentModel);
                }
            }, OperationContext.Stage.RUNTIME);
            handbackHolder.setHandback(parentModel);
        }
        return !restartServices;
    }

    protected boolean isResourceServiceRestartAllowed(OperationContext context, ServiceController<?> service) {
        return context.isResourceServiceRestartAllowed();
    }

    protected void removeServices(OperationContext context, ServiceName parentService, ModelNode parentModel) throws OperationFailedException {
        context.removeService(parentService);
    }

    protected void recreateParentService(OperationContext context, ModelNode parentModel) throws OperationFailedException {
        this.recreateParentService(context, context.getCurrentAddress(), parentModel);
    }

    @Deprecated(forRemoval=true)
    protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
    }

    protected abstract ServiceName getParentServiceName(PathAddress var1);

    protected PathAddress getParentAddress(PathAddress address) {
        return Util.getParentAddressByKey(address, this.parentKeyName);
    }

    @Override
    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode resolvedValue, final ModelNode invalidatedParentModel) throws OperationFailedException {
        if (invalidatedParentModel == null) {
            return;
        }
        PathAddress address = this.getParentAddress(context.getCurrentAddress());
        final ServiceName serviceName = this.getParentServiceName(address);
        final ModelNode parentModel = this.getOriginalModel(context, address);
        if (parentModel != null && context.revertResourceRestarted(address, this)) {
            context.addStep(Util.getReadResourceOperation(address), new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    RestartParentWriteAttributeHandler.this.removeServices(context, serviceName, invalidatedParentModel);
                    RestartParentWriteAttributeHandler.this.recreateParentService(context, parentModel);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private ModelNode getModel(OperationContext ctx, PathAddress address) {
        try {
            Resource resource = ctx.readResourceFromRoot(address);
            return Resource.Tools.readModel(resource);
        }
        catch (Resource.NoSuchResourceException e) {
            return null;
        }
    }

    private ModelNode getOriginalModel(OperationContext ctx, PathAddress address) {
        try {
            Resource resource = ctx.getOriginalRootResource().navigate(address);
            return Resource.Tools.readModel(resource);
        }
        catch (Resource.NoSuchResourceException e) {
            return null;
        }
    }
}

