/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.DB2SqlAstTranslator;
import org.hibernate.dialect.DB2StructJdbcType;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.DB2AggregateSupport;
import org.hibernate.dialect.function.CastingConcatFunction;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.CountFunction;
import org.hibernate.dialect.function.DB2FormatEmulation;
import org.hibernate.dialect.function.DB2PositionFunction;
import org.hibernate.dialect.function.DB2SubstringFunction;
import org.hibernate.dialect.identity.DB2IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.DB2LimitHandler;
import org.hibernate.dialect.pagination.LegacyDB2LimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.DB2SequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.unique.AlterTableUniqueIndexDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.mapping.Column;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.procedure.internal.DB2CallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.mutation.internal.cte.CteInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.cte.CteMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorDB2DatabaseImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorNoOpImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.CharJdbcType;
import org.hibernate.type.descriptor.jdbc.ClobJdbcType;
import org.hibernate.type.descriptor.jdbc.DecimalJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectNullResolvingJdbcType;
import org.hibernate.type.descriptor.jdbc.SmallIntJdbcType;
import org.hibernate.type.descriptor.jdbc.VarbinaryJdbcType;
import org.hibernate.type.descriptor.jdbc.VarcharJdbcType;
import org.hibernate.type.descriptor.jdbc.XmlJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class DB2Dialect
extends Dialect {
    static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make(10, 5);
    private static final int BIND_PARAMETERS_NUMBER_LIMIT = Short.MAX_VALUE;
    private static final String FOR_READ_ONLY_SQL = " for read only with rs";
    private static final String FOR_SHARE_SQL = " for read only with rs use and keep share locks";
    private static final String FOR_UPDATE_SQL = " for read only with rs use and keep update locks";
    private static final String SKIP_LOCKED_SQL = " skip locked data";
    private static final String FOR_SHARE_SKIP_LOCKED_SQL = " for read only with rs use and keep share locks skip locked data";
    private static final String FOR_UPDATE_SKIP_LOCKED_SQL = " for read only with rs use and keep update locks skip locked data";
    private final LimitHandler limitHandler = this.getDB2Version().isBefore(11, 1) ? LegacyDB2LimitHandler.INSTANCE : DB2LimitHandler.INSTANCE;
    private final UniqueDelegate uniqueDelegate = this.createUniqueDelegate();

    public DB2Dialect() {
        this(MINIMUM_VERSION);
    }

    public DB2Dialect(DialectResolutionInfo info) {
        super(info);
    }

    public DB2Dialect(DatabaseVersion version) {
        super(version);
    }

    @Override
    protected DatabaseVersion getMinimumSupportedVersion() {
        return MINIMUM_VERSION;
    }

    @Override
    protected void registerDefaultKeywords() {
        super.registerDefaultKeywords();
        this.registerKeyword("current");
        this.registerKeyword("date");
        this.registerKeyword("time");
        this.registerKeyword("timestamp");
        this.registerKeyword("fetch");
        this.registerKeyword("first");
        this.registerKeyword("rows");
        this.registerKeyword("only");
    }

    public DatabaseVersion getDB2Version() {
        return this.getVersion();
    }

    @Override
    public int getDefaultStatementBatchSize() {
        return 0;
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 16: {
                return this.getDB2Version().isBefore(11) ? "smallint" : super.columnType(sqlTypeCode);
            }
            case -6: {
                return "smallint";
            }
            case 2: {
                return this.columnType(3);
            }
            case 2004: {
                return "blob";
            }
            case 2005: {
                return "clob";
            }
            case 2014: {
                return "timestamp($p)";
            }
            case 92: 
            case 2013: {
                return "time";
            }
            case -2: {
                return this.getDB2Version().isBefore(11) ? "char($l) for bit data" : super.columnType(sqlTypeCode);
            }
            case -3: {
                return this.getDB2Version().isBefore(11) ? "varchar($l) for bit data" : super.columnType(sqlTypeCode);
            }
        }
        return super.columnType(sqlTypeCode);
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(2009, "xml", this));
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(-2, this.columnType(-3), this).withTypeCapacity(254L, this.columnType(-2)).build());
    }

    protected UniqueDelegate createUniqueDelegate() {
        return new AlterTableUniqueIndexDelegate(this);
    }

    @Override
    public int getMaxVarcharLength() {
        return 32672;
    }

    @Override
    public int getDefaultDecimalPrecision() {
        return 31;
    }

    @Override
    protected boolean supportsPredicateAsExpression() {
        return this.getDB2Version().isSameOrAfter(11);
    }

    @Override
    public boolean supportsDistinctFromPredicate() {
        return this.getDB2Version().isSameOrAfter(11, 1);
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.avg_castingNonDoubleArguments(this, SqlAstNodeRenderingMode.DEFAULT);
        functionFactory.cot();
        functionFactory.sinh();
        functionFactory.cosh();
        functionFactory.tanh();
        functionFactory.degrees();
        functionFactory.log10();
        functionFactory.radians();
        functionFactory.rand();
        functionFactory.soundex();
        functionFactory.trim2();
        functionFactory.space();
        functionFactory.repeat();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("substr").setInvariantType(functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.STRING)).setArgumentCountBetween(2, 3).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER).setArgumentListSignature("(STRING string, INTEGER start[, INTEGER length])").register();
        functionContributions.getFunctionRegistry().register("substring", new DB2SubstringFunction(functionContributions.getTypeConfiguration()));
        functionFactory.translate();
        functionFactory.bitand();
        functionFactory.bitor();
        functionFactory.bitxor();
        functionFactory.bitnot();
        functionFactory.yearMonthDay();
        functionFactory.hourMinuteSecond();
        functionFactory.dayofweekmonthyear();
        functionFactory.weekQuarter();
        functionFactory.daynameMonthname();
        functionFactory.lastDay();
        functionFactory.toCharNumberDateTimestamp();
        functionFactory.dateTimeTimestamp();
        functionFactory.concat_pipeOperator();
        functionFactory.octetLength();
        functionFactory.ascii();
        functionFactory.char_chr();
        functionFactory.insert();
        functionFactory.characterLength_length(SqlAstNodeRenderingMode.DEFAULT);
        functionFactory.stddev();
        functionFactory.regrLinearRegressionAggregates();
        functionFactory.variance();
        functionFactory.hypotheticalOrderedSetAggregates_windowEmulation();
        if (this.getDB2Version().isSameOrAfter(11)) {
            functionFactory.position();
            functionFactory.overlayLength_overlay(false);
            functionFactory.median();
            functionFactory.inverseDistributionOrderedSetAggregates();
            functionFactory.stddevPopSamp();
            functionFactory.varPopSamp();
            functionFactory.varianceSamp();
            functionFactory.dateTrunc();
            functionFactory.trunc_dateTrunc();
        } else {
            functionContributions.getFunctionRegistry().register("position", new DB2PositionFunction(functionContributions.getTypeConfiguration()));
            functionFactory.overlayLength_overlay(true);
            functionContributions.getFunctionRegistry().registerAlternateKey("stddev_pop", "stddev");
            functionFactory.stddevSamp_sumCount();
            functionContributions.getFunctionRegistry().registerAlternateKey("var_pop", "variance");
            functionFactory.varSamp_sumCount();
            functionFactory.trunc_dateTrunc_trunc();
        }
        functionFactory.addYearsMonthsDaysHoursMinutesSeconds();
        functionFactory.yearsMonthsDaysHoursMinutesSecondsBetween();
        functionFactory.bitLength_pattern("length(?1)*8");
        functionContributions.getFunctionRegistry().register("concat", new CastingConcatFunction(this, "||", true, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER, functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().register("count", new CountFunction(this, functionContributions.getTypeConfiguration(), SqlAstNodeRenderingMode.DEFAULT, "||", functionContributions.getTypeConfiguration().getDdlTypeRegistry().getDescriptor(12).getCastTypeName(functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.STRING), null, null, null), true));
        functionContributions.getFunctionRegistry().register("format", new DB2FormatEmulation(functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().patternDescriptorBuilder("atan2", "atan2(?2,?1)").setInvariantType(functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.DOUBLE)).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.NUMERIC, FunctionParameterType.NUMERIC).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("posstr").setInvariantType(functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER)).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.STRING).setArgumentListSignature("(STRING string, STRING pattern)").register();
        functionFactory.windowFunctions();
        functionFactory.listagg(null);
    }

    @Override
    public String[] getDropSchemaCommand(String schemaName) {
        return new String[]{"drop schema " + schemaName + " restrict"};
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000000000L;
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        String toExpression;
        String fromExpression;
        if (this.getDB2Version().isBefore(11)) {
            return DB2Dialect.timestampdiffPatternV10(unit, fromTemporalType, toTemporalType);
        }
        StringBuilder pattern = new StringBuilder();
        if (unit.isDateUnit()) {
            fromExpression = "?2";
            toExpression = "?3";
        } else {
            switch (fromTemporalType) {
                case DATE: {
                    fromExpression = "cast(?2 as timestamp)";
                    break;
                }
                case TIME: {
                    fromExpression = "timestamp('1970-01-01',?2)";
                    break;
                }
                default: {
                    fromExpression = "?2";
                }
            }
            switch (toTemporalType) {
                case DATE: {
                    toExpression = "cast(?3 as timestamp)";
                    break;
                }
                case TIME: {
                    toExpression = "timestamp('1970-01-01',?3)";
                    break;
                }
                default: {
                    toExpression = "?3";
                }
            }
        }
        switch (unit) {
            case NATIVE: 
            case NANOSECOND: {
                pattern.append("(seconds_between(");
                break;
            }
            case MONTH: 
            case QUARTER: {
                pattern.append("trunc(months_between(");
                break;
            }
            default: {
                pattern.append("?1s_between(");
            }
        }
        pattern.append(toExpression);
        pattern.append(',');
        pattern.append(fromExpression);
        pattern.append(')');
        switch (unit) {
            case NATIVE: {
                pattern.append("+(microsecond(");
                pattern.append(toExpression);
                pattern.append(")-microsecond(");
                pattern.append(fromExpression);
                pattern.append("))/1e6)");
                break;
            }
            case NANOSECOND: {
                pattern.append("*1e9+(microsecond(");
                pattern.append(toExpression);
                pattern.append(")-microsecond(");
                pattern.append(fromExpression);
                pattern.append("))*1e3)");
                break;
            }
            case MONTH: {
                pattern.append(')');
                break;
            }
            case QUARTER: {
                pattern.append("/3)");
            }
        }
        return pattern.toString();
    }

    public static String timestampdiffPatternV10(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        String toExpression;
        String fromExpression;
        boolean isTime;
        boolean bl = isTime = fromTemporalType == TemporalType.TIME || toTemporalType == TemporalType.TIME;
        if (unit.isDateUnit()) {
            fromExpression = fromTemporalType == TemporalType.TIME ? "timestamp('1970-01-01',?2)" : "?2";
            toExpression = toTemporalType == TemporalType.TIME ? "timestamp('1970-01-01',?3)" : "?3";
        } else {
            fromExpression = fromTemporalType == TemporalType.DATE ? "cast(?2 as timestamp)" : "?2";
            toExpression = toTemporalType == TemporalType.DATE ? "cast(?3 as timestamp)" : "?3";
        }
        switch (unit) {
            case NATIVE: {
                if (isTime) {
                    return "(midnight_seconds(" + toExpression + ")-midnight_seconds(" + fromExpression + "))";
                }
                return "(select (days(t2)-days(t1))*86400+(midnight_seconds(t2)-midnight_seconds(t1))+(microsecond(t2)-microsecond(t1))/1e6 from lateral(values(" + fromExpression + "," + toExpression + ")) as temp(t1,t2))";
            }
            case NANOSECOND: {
                if (isTime) {
                    return "(midnight_seconds(" + toExpression + ")-midnight_seconds(" + fromExpression + "))*1e9";
                }
                return "(select (days(t2)-days(t1))*86400+(midnight_seconds(t2)-midnight_seconds(t1))*1e9+(microsecond(t2)-microsecond(t1))*1e3 from lateral(values(" + fromExpression + "," + toExpression + ")) as temp(t1,t2))";
            }
            case SECOND: {
                if (isTime) {
                    return "(midnight_seconds(" + toExpression + ")-midnight_seconds(" + fromExpression + "))";
                }
                return "(select (days(t2)-days(t1))*86400+(midnight_seconds(t2)-midnight_seconds(t1)) from lateral(values(" + fromExpression + "," + toExpression + ")) as temp(t1,t2))";
            }
            case MINUTE: {
                if (isTime) {
                    return "(midnight_seconds(" + toExpression + ")-midnight_seconds(" + fromExpression + "))/60";
                }
                return "(select (days(t2)-days(t1))*1440+(midnight_seconds(t2)-midnight_seconds(t1))/60 from lateral(values(" + fromExpression + "," + toExpression + ")) as temp(t1,t2))";
            }
            case HOUR: {
                if (isTime) {
                    return "(midnight_seconds(" + toExpression + ")-midnight_seconds(" + fromExpression + "))/3600";
                }
                return "(select (days(t2)-days(t1))*24+(midnight_seconds(t2)-midnight_seconds(t1))/3600 from lateral(values(" + fromExpression + "," + toExpression + ")) as temp(t1,t2))";
            }
            case YEAR: {
                return "(year(" + toExpression + ")-year(" + fromExpression + "))";
            }
            case MONTH: {
                return "trunc(months_between(" + toExpression + "," + fromExpression + "))";
            }
            case QUARTER: {
                return "trunc(months_between(" + toExpression + "," + fromExpression + ")/3)";
            }
            case WEEK: {
                return "int((days" + toExpression + ")-days(" + fromExpression + "))/7)";
            }
            case DAY: {
                return "(days(" + toExpression + ")-days(" + fromExpression + "))";
            }
        }
        throw new UnsupportedOperationException("Unsupported unit: " + unit);
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        StringBuilder pattern = new StringBuilder();
        String timestampExpression = unit.isDateUnit() ? (temporalType == TemporalType.TIME ? "timestamp('1970-01-01',?3)" : "?3") : (temporalType == TemporalType.DATE ? "cast(?3 as timestamp)" : "?3");
        pattern.append(timestampExpression);
        pattern.append("+(");
        switch (unit) {
            case NATIVE: {
                pattern.append("?2) seconds");
                break;
            }
            case NANOSECOND: {
                pattern.append("(?2)/1e9) seconds");
                break;
            }
            case WEEK: {
                pattern.append("(?2)*7) days");
                break;
            }
            case QUARTER: {
                pattern.append("(?2)*3) months");
                break;
            }
            default: {
                pattern.append("?2) ?1s");
            }
        }
        return pattern.toString();
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsLocalTime(appender, temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithNanos(appender, temporalAccessor, false, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, date);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsLocalTime(appender, date);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithNanos(appender, date, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, calendar);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsLocalTime(appender, calendar);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithMillis(appender, calendar, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public String getCreateIndexTail(boolean unique, List<Column> columns) {
        return unique ? " exclude null keys" : "";
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return DB2SequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from syscat.sequences";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        if (this.getQuerySequencesString() == null) {
            return SequenceInformationExtractorNoOpImpl.INSTANCE;
        }
        return SequenceInformationExtractorDB2DatabaseImpl.INSTANCE;
    }

    @Override
    public String getForUpdateString() {
        return FOR_UPDATE_SQL;
    }

    @Override
    public boolean supportsSkipLocked() {
        return this.getDB2Version().isSameOrAfter(11, 5);
    }

    @Override
    public String getForUpdateSkipLockedString() {
        return this.supportsSkipLocked() ? FOR_UPDATE_SKIP_LOCKED_SQL : FOR_UPDATE_SQL;
    }

    @Override
    public String getForUpdateSkipLockedString(String aliases) {
        return this.getForUpdateSkipLockedString();
    }

    @Override
    public String getWriteLockString(int timeout) {
        return timeout == -2 && this.supportsSkipLocked() ? FOR_UPDATE_SKIP_LOCKED_SQL : FOR_UPDATE_SQL;
    }

    @Override
    public String getReadLockString(int timeout) {
        return timeout == -2 && this.supportsSkipLocked() ? FOR_SHARE_SKIP_LOCKED_SQL : FOR_SHARE_SQL;
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public boolean supportsExistsInSelect() {
        return false;
    }

    @Override
    public boolean supportsLockTimeouts() {
        return false;
    }

    @Override
    public boolean requiresCastForConcatenatingNonStrings() {
        return true;
    }

    @Override
    public String getSelectClauseNullString(int sqlType, TypeConfiguration typeConfiguration) {
        return DB2Dialect.selectNullString(sqlType);
    }

    public static String selectNullString(int sqlType) {
        String literal;
        switch (sqlType) {
            case 1: 
            case 12: {
                literal = "''";
                break;
            }
            case 91: {
                literal = "'2000-1-1'";
                break;
            }
            case 92: {
                literal = "'00:00:00'";
                break;
            }
            case 93: 
            case 2014: {
                literal = "'2000-1-1 00:00:00'";
                break;
            }
            default: {
                literal = "0";
            }
        }
        return "nullif(" + literal + "," + literal + ")";
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        return col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        boolean isResultSet = ps.execute();
        while (!isResultSet && ps.getUpdateCount() != -1) {
            isResultSet = ps.getMoreResults();
        }
        return ps.getResultSet();
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public String getAlterColumnTypeString(String columnName, String columnType, String columnDefinition) {
        return "alter column " + columnName + " set data type " + columnType;
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new CteMutationStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    @Override
    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new CteInsertStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    @Override
    public boolean supportsIsTrue() {
        return this.getDB2Version().isSameOrAfter(11);
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "values current timestamp";
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return false;
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        if (this.getDB2Version().isBefore(11)) {
            jdbcTypeRegistry.addDescriptor(16, SmallIntJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(-3, VarbinaryJdbcType.INSTANCE_WITHOUT_LITERALS);
            if (this.getDB2Version().isBefore(9, 7)) {
                jdbcTypeRegistry.addDescriptor(2, DecimalJdbcType.INSTANCE);
            }
        }
        jdbcTypeRegistry.addDescriptor(-15, CharJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(2011, this.useInputStreamToInsertBlob() ? ClobJdbcType.STREAM_BINDING : ClobJdbcType.CLOB_BINDING);
        jdbcTypeRegistry.addDescriptor(-9, VarcharJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(2, DecimalJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(XmlJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(DB2StructJdbcType.INSTANCE);
        typeContributions.contributeJdbcType(ObjectNullResolvingJdbcType.INSTANCE);
        typeContributions.contributeType(new JavaObjectType((JdbcType)ObjectNullResolvingJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)Object.class))));
    }

    @Override
    public AggregateSupport getAggregateSupport() {
        return DB2AggregateSupport.INSTANCE;
    }

    @Override
    public CallableStatementSupport getCallableStatementSupport() {
        return DB2CallableStatementSupport.INSTANCE;
    }

    @Override
    public void appendBinaryLiteral(SqlAppender appender, byte[] bytes) {
        if (this.getDB2Version().isSameOrAfter(11)) {
            appender.appendSql("BX'");
        } else {
            appender.appendSql("X'");
        }
        PrimitiveByteArrayJavaType.INSTANCE.appendString(appender, bytes);
        appender.appendSql('\'');
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
            int errorCode = JdbcExceptionHelper.extractErrorCode(sqlException);
            if (-952 == errorCode && "57014".equals(sqlState)) {
                throw new LockTimeoutException(message, sqlException, sql);
            }
            return null;
        };
    }

    @Override
    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    @Override
    public int getMaxIdentifierLength() {
        return 128;
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    @Override
    public boolean supportsNullPrecedence() {
        return false;
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new DB2SqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return DB2IdentityColumnSupport.INSTANCE;
    }

    @Override
    public boolean supportsInsertReturning() {
        return true;
    }

    @Override
    public boolean supportsValuesList() {
        return true;
    }

    @Override
    public boolean supportsPartitionBy() {
        return true;
    }

    @Override
    public boolean supportsNonQueryWithCTE() {
        return true;
    }

    @Override
    public boolean supportsRecursiveCTE() {
        return true;
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return true;
    }

    @Override
    public boolean supportsLateral() {
        return true;
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(OracleDialect.datetimeFormat(format, false, false).result());
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day";
            }
            case DAY_OF_YEAR: {
                return "doy";
            }
            case DAY_OF_WEEK: {
                return "dow";
            }
        }
        return super.translateExtractField(unit);
    }

    @Override
    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        if (this.getDB2Version().isBefore(11)) {
            appender.appendSql(bool ? (char)'1' : '0');
        } else {
            appender.appendSql(bool);
        }
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case WEEK: {
                return "week_iso(?2)";
            }
            case DAY_OF_YEAR: {
                return "dayofyear(?2)";
            }
            case DAY_OF_WEEK: {
                return "dayofweek(?2)";
            }
            case QUARTER: {
                return "quarter(?2)";
            }
            case EPOCH: {
                if (!this.getDB2Version().isBefore(11)) break;
                return this.timestampdiffPattern(TemporalUnit.SECOND, TemporalType.TIMESTAMP, TemporalType.TIMESTAMP).replace("?2", "'1970-01-01 00:00:00'").replace("?3", "?2");
            }
        }
        return super.extractPattern(unit);
    }

    @Override
    public int getInExpressionCountLimit() {
        return Short.MAX_VALUE;
    }

    @Override
    public String generatedAs(String generatedAs) {
        return " generated always as (" + generatedAs + ")";
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.setAutoQuoteInitialUnderscore(true);
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    @Override
    public boolean canDisableConstraints() {
        return true;
    }

    @Override
    public String getDisableConstraintStatement(String tableName, String name) {
        return "alter table " + tableName + " alter foreign key " + name + " not enforced";
    }

    @Override
    public String getEnableConstraintStatement(String tableName, String name) {
        return "alter table " + tableName + " alter foreign key " + name + " enforced";
    }

    @Override
    public String getTruncateTableStatement(String tableName) {
        return super.getTruncateTableStatement(tableName) + " immediate";
    }

    @Override
    public String getCreateUserDefinedTypeExtensionsString() {
        return " instantiable mode db2sql";
    }

    @Override
    public String rowId(String rowId) {
        return "rowid";
    }

    @Override
    public int rowIdSqlType() {
        return -3;
    }
}

