/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree;

import java.util.Map;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.cte.CteStatement;

public abstract class AbstractStatement
implements Statement,
CteContainer {
    private final Map<String, CteStatement> cteStatements;

    public AbstractStatement(Map<String, CteStatement> cteStatements) {
        this.cteStatements = cteStatements;
    }

    @Override
    public Map<String, CteStatement> getCteStatements() {
        return this.cteStatements;
    }

    @Override
    public CteStatement getCteStatement(String cteLabel) {
        return this.cteStatements.get(cteLabel);
    }

    @Override
    public void addCteStatement(CteStatement cteStatement) {
        if (this.cteStatements.putIfAbsent(cteStatement.getCteTable().getTableExpression(), cteStatement) != null) {
            throw new IllegalArgumentException("A CTE with the label " + cteStatement.getCteTable().getTableExpression() + " already exists");
        }
    }
}

