/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.coordinator.internal;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.ActionStatus;
import io.narayana.lra.coordinator.domain.model.LongRunningAction;
import io.narayana.lra.coordinator.domain.service.LRAService;
import io.narayana.lra.logging.LRALogger;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.microprofile.lra.annotation.LRAStatus;

class RecoveringLRA
extends LongRunningAction {
    private int _theStatus;
    private boolean _activated = false;

    RecoveringLRA(LRAService lraService, Uid rcvUid, int theStatus) {
        super(lraService, rcvUid);
        this._theStatus = theStatus;
        this._activated = this.activate();
    }

    public boolean isActivated() {
        return this._activated;
    }

    public void replayPhase2() {
        ReentrantLock lock = this.tryLockTransaction();
        if (lock == null) {
            return;
        }
        try {
            this.tryReplayPhase2();
        }
        finally {
            lock.unlock();
        }
    }

    private void tryReplayPhase2() {
        if (LRALogger.logger.isDebugEnabled()) {
            LRALogger.logger.debugf("RecoveringLRA.replayPhase2 recovering %s ActionStatus is %s", (Object)this.get_uid(), (Object)ActionStatus.stringForm((int)this._theStatus));
        }
        if (this._activated) {
            if (this._theStatus == 5 || this._theStatus == 6 || this._theStatus == 7 || this._theStatus == 12 || this._theStatus == 13 || this._theStatus == 14) {
                if (this.heuristicList.size() != 0 || this.pendingList.size() != 0 || this.getLRAStatus() == LRAStatus.Active) {
                    this.moveTo(this.heuristicList, this.preparedList);
                    this.moveTo(this.pendingList, this.preparedList);
                    this.checkParticipant(this.preparedList);
                    super.phase2Commit(true);
                    this.runPostLRAActions();
                    if (this.heuristicList.size() == 0 && this.failedList.size() == 0) {
                        this.updateState(this.toLRAStatus(this._theStatus));
                    }
                    switch (this.getLRAStatus()) {
                        case Closed: 
                        case Cancelled: 
                        case FailedToClose: 
                        case FailedToCancel: {
                            this.getLraService().finished(this, false);
                            break;
                        }
                        default: {
                            if (LRALogger.logger.isInfoEnabled()) {
                                LRALogger.logger.infof("RecoveringLRA.replayPhase2 for %s ended with status: %s", (Object)this.getId().toASCIIString(), (Object)this.getLRAStatus());
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                }
            } else if (LRALogger.logger.isInfoEnabled()) {
                LRALogger.logger.info((Object)("RecoveringLRA.replayPhase2: Unexpected status: " + ActionStatus.stringForm((int)this._theStatus)));
            }
        } else if (LRALogger.logger.isInfoEnabled()) {
            LRALogger.logger.infof("RecoveringLRA: LRA %s not activated, unable to replay phase 2 commit, will retry later", (Object)this.get_uid());
        }
    }
}

