/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.sql.Time;
import java.time.Instant;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.AbstractConvertingDelegatingDefaultBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultInstantBridge;

public final class DefaultJavaSqlTimeBridge
extends AbstractConvertingDelegatingDefaultBridge<Time, Instant> {
    public static final DefaultJavaSqlTimeBridge INSTANCE = new DefaultJavaSqlTimeBridge();

    public DefaultJavaSqlTimeBridge() {
        super(DefaultInstantBridge.INSTANCE);
    }

    @Override
    protected Instant toConvertedValue(Time value) {
        return Instant.ofEpochMilli(value.getTime());
    }

    @Override
    protected Time fromConvertedValue(Instant value) {
        return new Time(value.toEpochMilli());
    }
}

