/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.opentelemetry;

import java.util.EnumSet;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.PersistentResourceXMLDescriptionReader;
import org.jboss.as.controller.PersistentResourceXMLDescriptionWriter;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.extension.opentelemetry.OpenTelemetrySubsystemDefinition;
import org.wildfly.extension.opentelemetry.OpenTelemetrySubsystemModel;
import org.wildfly.extension.opentelemetry.OpenTelemetrySubsystemSchema;

public class OpenTelemetrySubsystemExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "opentelemetry";
    public static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"opentelemetry");
    static final ParentResourceDescriptionResolver SUBSYSTEM_RESOLVER = new SubsystemResourceDescriptionResolver("opentelemetry", OpenTelemetrySubsystemExtension.class);
    private final PersistentResourceXMLDescription currentDescription = OpenTelemetrySubsystemSchema.CURRENT.getXMLDescription();

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, OpenTelemetrySubsystemModel.CURRENT.getVersion());
        subsystem.registerXMLElementWriter((XMLElementWriter)new PersistentResourceXMLDescriptionWriter(this.currentDescription));
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)new OpenTelemetrySubsystemDefinition());
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (OpenTelemetrySubsystemSchema schema : EnumSet.allOf(OpenTelemetrySubsystemSchema.class)) {
            OpenTelemetrySubsystemSchema reader = schema == OpenTelemetrySubsystemSchema.CURRENT ? new PersistentResourceXMLDescriptionReader(this.currentDescription) : schema;
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, schema.getNamespace().getUri(), (XMLElementReader)reader);
        }
    }
}

