/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelPool;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class ChannelRecord
extends CompletableFuture<Channel>
implements GenericFutureListener<ChannelFuture> {
    private static final Log log = LogFactory.getLog(ChannelRecord.class);
    static AttributeKey<ChannelRecord> KEY = AttributeKey.newInstance((String)"activation");
    private final SocketAddress unresolvedAddress;
    private final ChannelPool channelPool;
    private boolean closed = false;
    private boolean acquired = true;

    ChannelRecord(SocketAddress unresolvedAddress, ChannelPool channelPool) {
        this.unresolvedAddress = unresolvedAddress;
        this.channelPool = channelPool;
    }

    public static ChannelRecord of(Channel channel) {
        return (ChannelRecord)channel.attr(KEY).get();
    }

    public SocketAddress getUnresolvedAddress() {
        return this.unresolvedAddress;
    }

    @Override
    public boolean complete(Channel channel) {
        boolean complete = super.complete(channel);
        if (complete) {
            channel.closeFuture().addListener((GenericFutureListener)this);
        }
        return complete;
    }

    public void operationComplete(ChannelFuture future) throws Exception {
        if (log.isTraceEnabled() && !future.isSuccess()) {
            log.tracef(future.cause(), "Channel %s is closed, see exception for details", this.get());
        }
        this.channelPool.releaseClosedChannel(future.channel(), this);
        this.channelPool.inspectPool();
    }

    synchronized void setAcquired() {
        assert (!this.acquired);
        this.acquired = true;
    }

    public synchronized boolean isIdle() {
        return !this.acquired;
    }

    public synchronized boolean setIdleAndIsClosed() {
        assert (this.acquired);
        this.acquired = false;
        return this.closed;
    }

    public synchronized boolean closeAndWasIdle() {
        assert (!this.closed);
        this.closed = true;
        return !this.acquired;
    }

    public void release(Channel channel) {
        this.channelPool.release(channel, this);
    }
}

