/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.encoding;

import com.fasterxml.jackson.databind.JsonNode;
import io.smallrye.openapi.api.models.media.EncodingImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.io.header.HeaderReader;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.Annotations;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class EncodingReader {
    private static final Map<String, Encoding.Style> ENCODING_STYLE_LOOKUP;

    private EncodingReader() {
    }

    public static Map<String, Encoding> readEncodings(AnnotationScannerContext context, AnnotationValue annotationValue) {
        AnnotationInstance[] nestedArray;
        if (annotationValue == null) {
            return null;
        }
        IoLogging.logger.annotationsMap("@Encoding");
        LinkedHashMap<String, Encoding> encodings = new LinkedHashMap<String, Encoding>();
        for (AnnotationInstance annotation : nestedArray = annotationValue.asNestedArray()) {
            String name = (String)Annotations.value(annotation, "name");
            if (name == null) continue;
            encodings.put(name, EncodingReader.readEncoding(context, annotation));
        }
        return encodings;
    }

    public static Map<String, Encoding> readEncodings(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        IoLogging.logger.jsonNodeMap("Encoding");
        LinkedHashMap<String, Encoding> encodings = new LinkedHashMap<String, Encoding>();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String name = (String)fieldNames.next();
            encodings.put(name, EncodingReader.readEncoding(node.get(name)));
        }
        return encodings;
    }

    private static Encoding readEncoding(AnnotationScannerContext context, AnnotationInstance annotationInstance) {
        if (annotationInstance == null) {
            return null;
        }
        IoLogging.logger.singleAnnotation("@Encoding");
        EncodingImpl encoding = new EncodingImpl();
        encoding.setContentType((String)Annotations.value(annotationInstance, "contentType"));
        encoding.setStyle(EncodingReader.readEncodingStyle(annotationInstance));
        encoding.setExplode((Boolean)Annotations.value(annotationInstance, "explode"));
        encoding.setAllowReserved((Boolean)Annotations.value(annotationInstance, "allowReserved"));
        encoding.setHeaders(HeaderReader.readHeaders(context, annotationInstance.value("headers")));
        encoding.setExtensions(ExtensionReader.readExtensions(context, annotationInstance));
        return encoding;
    }

    static Encoding.Style readEncodingStyle(AnnotationInstance encodingAnnotation) {
        String encodingStyle = (String)Annotations.value(encodingAnnotation, "style");
        return Stream.of((Encoding.Style[])Encoding.Style.class.getEnumConstants()).filter(style -> style.toString().equals(encodingStyle)).findFirst().orElse(null);
    }

    private static Encoding readEncoding(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        IoLogging.logger.singleJsonNode("Encoding");
        EncodingImpl encoding = new EncodingImpl();
        encoding.setContentType(JsonUtil.stringProperty(node, "contentType"));
        encoding.setHeaders(HeaderReader.readHeaders(node.get("headers")));
        encoding.setStyle(EncodingReader.readEncodingStyle(node.get("style")));
        encoding.setExplode(JsonUtil.booleanProperty(node, "explode").orElse(null));
        encoding.setAllowReserved(JsonUtil.booleanProperty(node, "allowReserved").orElse(null));
        ExtensionReader.readExtensions(node, encoding);
        return encoding;
    }

    private static Encoding.Style readEncodingStyle(JsonNode node) {
        if (node == null || !node.isTextual()) {
            return null;
        }
        return ENCODING_STYLE_LOOKUP.get(node.asText());
    }

    static {
        Encoding.Style[] encodingStyleValues;
        ENCODING_STYLE_LOOKUP = new LinkedHashMap<String, Encoding.Style>();
        for (Encoding.Style style : encodingStyleValues = Encoding.Style.values()) {
            ENCODING_STYLE_LOOKUP.put(style.toString(), style);
        }
    }
}

