/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentelemetry.implementation.exporters;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.http.HttpExporter;
import io.opentelemetry.exporter.internal.http.HttpSender;
import io.opentelemetry.exporter.internal.otlp.traces.TraceRequestMarshaler;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.smallrye.opentelemetry.implementation.exporters.OtlpExporterUtil;
import io.smallrye.opentelemetry.implementation.exporters.VertxGrpcExporter;
import io.smallrye.opentelemetry.implementation.exporters.VertxHttpExporter;
import io.vertx.core.Vertx;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;

public class VertxExporterProvider
implements ConfigurableSpanExporterProvider {
    protected static final String EXPORTER_NAME = "otlp";
    protected static final String OTLP_GRPC_ENDPOINT = "http://localhost:4317";
    protected static final String OTLP_HTTP_PROTOBUF_ENDPOINT = "http://localhost:4318";

    public SpanExporter createExporter(ConfigProperties config) {
        try {
            String otlpProtocol;
            switch (otlpProtocol = config.getString("otel.exporter.otlp.traces.protocol", config.getString("otel.exporter.otlp.protocol", "grpc"))) {
                case "grpc": {
                    return new VertxGrpcExporter(EXPORTER_NAME, "span", MeterProvider::noop, new URI(VertxExporterProvider.getOtlpEndpoint(config, OTLP_GRPC_ENDPOINT)), true, config.getDuration("otel.exporter.otlp.timeout", Duration.ofSeconds(10L)), OtlpExporterUtil.populateTracingExportHttpHeaders(), Vertx.vertx());
                }
                case "http/protobuf": {
                    return new VertxHttpExporter((HttpExporter<TraceRequestMarshaler>)new HttpExporter(EXPORTER_NAME, "span", (HttpSender)new VertxHttpExporter.VertxHttpSender(new URI(VertxExporterProvider.getOtlpEndpoint(config, OTLP_HTTP_PROTOBUF_ENDPOINT)), true, config.getDuration("otel.exporter.otlp.timeout", Duration.ofSeconds(10L)), OtlpExporterUtil.populateTracingExportHttpHeaders(), "application/x-protobuf", Vertx.vertx()), MeterProvider::noop, false));
                }
            }
            throw new RuntimeException("Unsupported OTLP protocol: " + otlpProtocol);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return EXPORTER_NAME;
    }

    private static String getOtlpEndpoint(ConfigProperties config, String defaultEndpoint) {
        return config.getString("otel.exporter.otlp.traces.endpoint", config.getString("otel.exporter.otlp.endpoint", defaultEndpoint));
    }
}

