/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.federation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.settings.impl.Match;

public class FederationReceiveFromQueuePolicy
implements BiPredicate<String, String> {
    private final Set<QueueMatcher> includeMatchers = new LinkedHashSet<QueueMatcher>();
    private final Set<QueueMatcher> excludeMatchers = new LinkedHashSet<QueueMatcher>();
    private final Collection<Map.Entry<String, String>> includes;
    private final Collection<Map.Entry<String, String>> excludes;
    private final String policyName;
    private final boolean includeFederated;
    private final int priorityAdjustment;
    private final Map<String, Object> properties;
    private final TransformerConfiguration transformerConfig;

    public FederationReceiveFromQueuePolicy(String name, boolean includeFederated, int priorotyAdjustment, Collection<Map.Entry<String, String>> includeQueues, Collection<Map.Entry<String, String>> excludeQueues, Map<String, Object> properties, TransformerConfiguration transformerConfig, WildcardConfiguration wildcardConfig) {
        Objects.requireNonNull(name, "The provided policy name cannot be null");
        Objects.requireNonNull(wildcardConfig, "The provided wild card configuration cannot be null");
        this.policyName = name;
        this.includeFederated = includeFederated;
        this.priorityAdjustment = priorotyAdjustment;
        this.transformerConfig = transformerConfig;
        this.includes = Collections.unmodifiableCollection(includeQueues == null ? Collections.EMPTY_LIST : includeQueues);
        this.excludes = Collections.unmodifiableCollection(excludeQueues == null ? Collections.EMPTY_LIST : excludeQueues);
        this.properties = properties == null || properties.isEmpty() ? Collections.EMPTY_MAP : Collections.unmodifiableMap(new HashMap<String, Object>(properties));
        this.includes.forEach(entry -> this.includeMatchers.add(new QueueMatcher((String)entry.getKey(), (String)entry.getValue(), wildcardConfig)));
        this.excludes.forEach(entry -> this.excludeMatchers.add(new QueueMatcher((String)entry.getKey(), (String)entry.getValue(), wildcardConfig)));
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public boolean isIncludeFederated() {
        return this.includeFederated;
    }

    public int getPriorityAjustment() {
        return this.priorityAdjustment;
    }

    public Collection<Map.Entry<String, String>> getIncludes() {
        return this.includes;
    }

    public Collection<Map.Entry<String, String>> getExcludes() {
        return this.excludes;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public TransformerConfiguration getTransformerConfiguration() {
        return this.transformerConfig;
    }

    @Override
    public boolean test(String address, String queue) {
        for (QueueMatcher matcher : this.excludeMatchers) {
            if (!matcher.test(address, queue)) continue;
            return false;
        }
        for (QueueMatcher matcher : this.includeMatchers) {
            if (!matcher.test(address, queue)) continue;
            return true;
        }
        return false;
    }

    private class QueueMatcher
    implements BiPredicate<String, String> {
        private final Predicate<String> addressMatch;
        private final Predicate<String> queueMatch;

        QueueMatcher(String address, String queue, WildcardConfiguration wildcardConfig) {
            this.addressMatch = address == null || address.isEmpty() ? target -> true : new Match(address, null, wildcardConfig).getPattern().asPredicate();
            this.queueMatch = queue == null || queue.isEmpty() ? target -> true : new Match(queue, null, wildcardConfig).getPattern().asPredicate();
        }

        @Override
        public boolean test(String address, String queue) {
            return this.addressMatch.test(address) && this.queueMatch.test(queue);
        }
    }
}

