/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.List;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.AbstractSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.function.FunctionRenderer;
import org.hibernate.query.sqm.function.SelfRenderingSqmAggregateFunction;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SelfRenderingSqmOrderedSetAggregateFunction;
import org.hibernate.query.sqm.function.SelfRenderingSqmWindowFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentTypeResolver;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;

public abstract class AbstractSqmSelfRenderingFunctionDescriptor
extends AbstractSqmFunctionDescriptor
implements FunctionRenderer {
    private final FunctionKind functionKind;

    public AbstractSqmSelfRenderingFunctionDescriptor(String name, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, FunctionArgumentTypeResolver argumentTypeResolver) {
        super(name, argumentsValidator, returnTypeResolver, argumentTypeResolver);
        this.functionKind = FunctionKind.NORMAL;
    }

    public AbstractSqmSelfRenderingFunctionDescriptor(String name, FunctionKind functionKind, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, FunctionArgumentTypeResolver argumentTypeResolver) {
        super(name, argumentsValidator, returnTypeResolver, argumentTypeResolver);
        this.functionKind = functionKind;
    }

    @Override
    public FunctionKind getFunctionKind() {
        return this.functionKind;
    }

    @Override
    protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, QueryEngine queryEngine) {
        switch (this.functionKind) {
            case ORDERED_SET_AGGREGATE: {
                return this.generateOrderedSetAggregateSqmExpression(arguments, null, null, impliedResultType, queryEngine);
            }
            case AGGREGATE: {
                return this.generateAggregateSqmExpression(arguments, null, impliedResultType, queryEngine);
            }
            case WINDOW: {
                return this.generateWindowSqmExpression(arguments, null, null, null, impliedResultType, queryEngine);
            }
        }
        return new SelfRenderingSqmFunction<T>((SqmFunctionDescriptor)this, this, arguments, impliedResultType, this.getArgumentsValidator(), this.getReturnTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName());
    }

    @Override
    public <T> SelfRenderingSqmAggregateFunction<T> generateSqmAggregateFunctionExpression(List<? extends SqmTypedNode<?>> arguments, SqmPredicate filter, ReturnableType<T> impliedResultType, QueryEngine queryEngine) {
        if (this.functionKind != FunctionKind.AGGREGATE) {
            throw new UnsupportedOperationException("The function " + this.getName() + " is not an aggregate function");
        }
        return new SelfRenderingSqmAggregateFunction<T>((SqmFunctionDescriptor)this, this, arguments, filter, impliedResultType, this.getArgumentsValidator(), this.getReturnTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName());
    }

    public <T> SelfRenderingSqmOrderedSetAggregateFunction<T> generateSqmOrderedSetAggregateFunctionExpression(List<? extends SqmTypedNode<?>> arguments, SqmPredicate filter, SqmOrderByClause withinGroupClause, ReturnableType<T> impliedResultType, QueryEngine queryEngine) {
        if (this.functionKind != FunctionKind.ORDERED_SET_AGGREGATE) {
            throw new UnsupportedOperationException("The function " + this.getName() + " is not an ordered set-aggregate function");
        }
        return new SelfRenderingSqmOrderedSetAggregateFunction<T>((SqmFunctionDescriptor)this, this, arguments, filter, withinGroupClause, impliedResultType, this.getArgumentsValidator(), this.getReturnTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName());
    }

    @Override
    protected <T> SelfRenderingSqmWindowFunction<T> generateSqmWindowFunctionExpression(List<? extends SqmTypedNode<?>> arguments, SqmPredicate filter, Boolean respectNulls, Boolean fromFirst, ReturnableType<T> impliedResultType, QueryEngine queryEngine) {
        if (this.functionKind != FunctionKind.WINDOW) {
            throw new UnsupportedOperationException("The function " + this.getName() + " is not a window function");
        }
        return new SelfRenderingSqmWindowFunction<T>((SqmFunctionDescriptor)this, this, arguments, filter, respectNulls, fromFirst, impliedResultType, this.getArgumentsValidator(), this.getReturnTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName());
    }
}

