/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.collection.spi.AbstractPersistentCollection;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.MarkerObject;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.sql.results.graph.collection.LoadingCollectionEntry;
import org.hibernate.type.AbstractType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public abstract class CollectionType
extends AbstractType
implements AssociationType {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)CollectionType.class.getName());
    public static final Object UNFETCHED_COLLECTION = new MarkerObject("UNFETCHED COLLECTION");
    private final String role;
    private final String foreignKeyPropertyName;
    private volatile CollectionPersister persister;

    public CollectionType(String role, String foreignKeyPropertyName) {
        this.role = role;
        this.foreignKeyPropertyName = foreignKeyPropertyName;
    }

    public abstract CollectionClassification getCollectionClassification();

    public String getRole() {
        return this.role;
    }

    public Object indexOf(Object collection, Object element) {
        throw new UnsupportedOperationException("generic collections don't have indexes");
    }

    public boolean contains(Object collection, Object childObject, SharedSessionContractImplementor session) {
        Iterator<?> elems = this.getElementsIterator(collection);
        while (elems.hasNext()) {
            Object element = elems.next();
            LazyInitializer li = HibernateProxy.extractLazyInitializer(element);
            if (li != null && !li.isUninitialized()) {
                element = li.getImplementation();
            }
            if (element != childObject) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCollectionType() {
        return true;
    }

    @Override
    public final boolean isEqual(Object x, Object y) {
        return x == y || x instanceof PersistentCollection && this.isEqual((PersistentCollection)x, y) || y instanceof PersistentCollection && this.isEqual((PersistentCollection)y, x);
    }

    private boolean isEqual(PersistentCollection<?> x, Object y) {
        return x.wasInitialized() && (x.isWrapper(y) || x.isDirectlyProvidedCollection(y));
    }

    @Override
    public int compare(Object x, Object y) {
        return 0;
    }

    @Override
    public int compare(Object x, Object y, SessionFactoryImplementor sessionFactory) {
        return this.compare(x, y);
    }

    @Override
    public int getHashCode(Object x) {
        throw new UnsupportedOperationException("cannot doAfterTransactionCompletion lookups on collections");
    }

    public abstract PersistentCollection<?> instantiate(SharedSessionContractImplementor var1, CollectionPersister var2, Object var3);

    @Override
    public final void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SharedSessionContractImplementor session) throws HibernateException, SQLException {
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
    }

    @Override
    public int[] getSqlTypeCodes(Mapping session) throws MappingException {
        return ArrayHelper.EMPTY_INT_ARRAY;
    }

    @Override
    public int getColumnSpan(Mapping session) throws MappingException {
        return 0;
    }

    @Override
    public String toLoggableString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        if (value == null) {
            return "null";
        }
        if (!this.getReturnedClass().isInstance(value) && !(value instanceof PersistentCollection)) {
            CollectionPersister persister = this.getPersister(factory);
            if (persister.getKeyType().getReturnedClass().isInstance(value)) {
                return this.getRole() + "#" + this.getPersister(factory).getKeyType().toLoggableString(value, factory);
            }
            if (persister.getIdentifierType() != null && persister.getIdentifierType().getReturnedClass().isInstance(value)) {
                return this.getRole() + "#" + this.getPersister(factory).getIdentifierType().toLoggableString(value, factory);
            }
        }
        return this.renderLoggableString(value, factory);
    }

    protected String renderLoggableString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        if (!Hibernate.isInitialized(value)) {
            return "<uninitialized>";
        }
        ArrayList<String> list = new ArrayList<String>();
        Type elemType = this.getElementType(factory);
        Iterator<?> itr = this.getElementsIterator(value);
        while (itr.hasNext()) {
            Object element = itr.next();
            String string = element == LazyPropertyInitializer.UNFETCHED_PROPERTY || !Hibernate.isInitialized(element) ? "<uninitialized>" : elemType.toLoggableString(element, factory);
            list.add(string);
        }
        return ((Object)list).toString();
    }

    @Override
    public Object deepCopy(Object value, SessionFactoryImplementor factory) {
        return value;
    }

    @Override
    public String getName() {
        return this.getReturnedClass().getName() + "(" + this.getRole() + ")";
    }

    @Deprecated
    public Iterator<?> getElementsIterator(Object collection, SharedSessionContractImplementor session) {
        return this.getElementsIterator(collection);
    }

    public Iterator<?> getElementsIterator(Object collection) {
        return ((Collection)collection).iterator();
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public Serializable disassemble(Object value, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        Object key = this.getKeyOfOwner(owner, session);
        return key == null ? null : this.getPersister(session).getKeyType().disassemble(key, session, owner);
    }

    @Override
    public Serializable disassemble(Object value, SessionFactoryImplementor sessionFactory) throws HibernateException {
        throw new UnsupportedOperationException("CollectionType not supported as part of cache key!");
    }

    @Override
    public Object assemble(Serializable cached, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        if (cached == null) {
            return null;
        }
        Object key = this.getPersister(session).getKeyType().assemble(cached, session, owner);
        return this.resolveKey(key, session, owner);
    }

    private CollectionPersister getPersister(SharedSessionContractImplementor session) {
        CollectionPersister p = this.persister;
        return p != null ? p : this.getPersister(session.getFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CollectionPersister getPersister(SessionFactoryImplementor factory) {
        CollectionPersister p = this.persister;
        if (p != null) {
            return p;
        }
        CollectionType collectionType = this;
        synchronized (collectionType) {
            p = this.persister;
            if (p != null) {
                return p;
            }
            this.persister = p = factory.getRuntimeMetamodels().getMappingMetamodel().getCollectionDescriptor(this.role);
            return p;
        }
    }

    @Override
    public boolean isDirty(Object old, Object current, SharedSessionContractImplementor session) throws HibernateException {
        return super.isDirty(old, current, session);
    }

    @Override
    public boolean isDirty(Object old, Object current, boolean[] checkable, SharedSessionContractImplementor session) throws HibernateException {
        return this.isDirty(old, current, session);
    }

    public abstract PersistentCollection<?> wrap(SharedSessionContractImplementor var1, Object var2);

    @Override
    public boolean isAssociationType() {
        return true;
    }

    @Override
    public ForeignKeyDirection getForeignKeyDirection() {
        return ForeignKeyDirection.TO_PARENT;
    }

    public Object getKeyOfOwner(Object owner, SharedSessionContractImplementor session) {
        PersistenceContext pc = session.getPersistenceContextInternal();
        EntityEntry entityEntry = pc.getEntry(owner);
        if (entityEntry == null) {
            return null;
        }
        if (this.foreignKeyPropertyName == null) {
            return entityEntry.getId();
        }
        Object id = entityEntry.getLoadedState() != null ? entityEntry.getLoadedValue(this.foreignKeyPropertyName) : entityEntry.getPersister().getPropertyValue(owner, this.foreignKeyPropertyName);
        Type keyType = this.getPersister(session).getKeyType();
        if (!keyType.getReturnedClass().isInstance(id)) {
            throw new UnsupportedOperationException("Re-work support for semi-resolve");
        }
        return id;
    }

    public Object getIdOfOwnerOrNull(Object key, SharedSessionContractImplementor session) {
        Object ownerId = null;
        if (this.foreignKeyPropertyName == null) {
            ownerId = key;
        } else {
            CollectionPersister persister = this.getPersister(session);
            Type keyType = persister.getKeyType();
            EntityPersister ownerPersister = persister.getOwnerEntityPersister();
            Class<?> ownerMappedClass = ownerPersister.getMappedClass();
            if (ownerMappedClass.isAssignableFrom(keyType.getReturnedClass()) && keyType.getReturnedClass().isInstance(key)) {
                ownerId = ownerPersister.getIdentifier(key, session);
            }
        }
        return ownerId;
    }

    private Object resolveKey(Object key, SharedSessionContractImplementor session, Object owner) {
        return key == null ? null : this.getCollection(key, session, owner, null);
    }

    public boolean isArrayType() {
        return false;
    }

    @Override
    public boolean useLHSPrimaryKey() {
        return this.foreignKeyPropertyName == null;
    }

    @Override
    public String getRHSUniqueKeyPropertyName() {
        return null;
    }

    @Override
    public Joinable getAssociatedJoinable(SessionFactoryImplementor factory) throws MappingException {
        return (Joinable)((Object)factory.getRuntimeMetamodels().getMappingMetamodel().getCollectionDescriptor(this.role));
    }

    @Override
    public boolean isModified(Object old, Object current, boolean[] checkable, SharedSessionContractImplementor session) {
        return false;
    }

    @Override
    public String getAssociatedEntityName(SessionFactoryImplementor factory) throws MappingException {
        try {
            QueryableCollection collectionPersister = (QueryableCollection)factory.getRuntimeMetamodels().getMappingMetamodel().getCollectionDescriptor(this.role);
            if (!collectionPersister.getElementType().isEntityType()) {
                throw new MappingException("collection was not an association: " + collectionPersister.getRole());
            }
            return collectionPersister.getElementPersister().getEntityName();
        }
        catch (ClassCastException cce) {
            throw new MappingException("collection role is not queryable " + this.role);
        }
    }

    public Object replaceElements(Object original, Object target, Object owner, Map<Object, Object> copyCache, SharedSessionContractImplementor session) {
        Collection result = (Collection)target;
        result.clear();
        Type elemType = this.getElementType(session.getFactory());
        for (Object o : (Collection)original) {
            result.add(elemType.replace(o, null, session, owner, copyCache));
        }
        if (original instanceof PersistentCollection && result instanceof PersistentCollection) {
            PersistentCollection originalPersistentCollection = (PersistentCollection)original;
            PersistentCollection resultPersistentCollection = (PersistentCollection)((Object)result);
            this.preserveSnapshot(originalPersistentCollection, resultPersistentCollection, elemType, owner, copyCache, session);
            if (!originalPersistentCollection.isDirty()) {
                resultPersistentCollection.clearDirty();
            }
        }
        return result;
    }

    private void preserveSnapshot(PersistentCollection<?> original, PersistentCollection<?> result, Type elemType, Object owner, Map<Object, Object> copyCache, SharedSessionContractImplementor session) {
        Serializable targetSnapshot;
        Serializable originalSnapshot = original.getStoredSnapshot();
        ArrayList<Object> resultSnapshot = result.getStoredSnapshot();
        if (originalSnapshot instanceof List) {
            ArrayList<Object> targetList;
            targetSnapshot = targetList = new ArrayList<Object>(((List)((Object)originalSnapshot)).size());
            for (Object e : (List)((Object)originalSnapshot)) {
                targetList.add(elemType.replace(e, null, session, owner, copyCache));
            }
        } else if (originalSnapshot instanceof Map) {
            AbstractMap targetMap;
            if (originalSnapshot instanceof SortedMap) {
                Comparator comparator = ((SortedMap)((Object)originalSnapshot)).comparator();
                targetMap = new TreeMap(comparator);
            } else {
                targetMap = new HashMap(CollectionHelper.determineProperSizing(((Map)((Object)originalSnapshot)).size()), 0.75f);
            }
            targetSnapshot = (Serializable)((Object)targetMap);
            for (Map.Entry entry : ((Map)((Object)originalSnapshot)).entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                Object resultSnapshotValue = resultSnapshot == null ? null : ((Map)((Object)resultSnapshot)).get(key);
                Object newValue = elemType.replace(value, resultSnapshotValue, session, owner, copyCache);
                if (key == value) {
                    targetMap.put(newValue, newValue);
                    continue;
                }
                targetMap.put(key, newValue);
            }
        } else if (originalSnapshot instanceof Object[]) {
            Object[] arr = (Object[])originalSnapshot;
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = elemType.replace(arr[i], null, session, owner, copyCache);
            }
            targetSnapshot = originalSnapshot;
        } else {
            targetSnapshot = resultSnapshot;
        }
        CollectionEntry ce = session.getPersistenceContextInternal().getCollectionEntry(result);
        if (ce != null) {
            ce.resetStoredSnapshot(result, targetSnapshot);
        }
    }

    protected Object instantiateResult(Object original) {
        return this.instantiate(-1);
    }

    public abstract Object instantiate(int var1);

    @Override
    public Object replace(Object original, Object target, SharedSessionContractImplementor session, Object owner, Map<Object, Object> copyCache) throws HibernateException {
        if (original == null) {
            return null;
        }
        if (!Hibernate.isInitialized(original)) {
            if (((PersistentCollection)original).hasQueuedOperations()) {
                if (original == target) {
                    AbstractPersistentCollection pc = (AbstractPersistentCollection)original;
                    pc.replaceQueuedOperationValues(this.getPersister(session), copyCache);
                } else {
                    LOG.ignoreQueuedOperationsOnMerge(MessageHelper.collectionInfoString(this.getRole(), ((PersistentCollection)original).getKey()));
                }
            }
            return target;
        }
        Object result = target == null || target == original || target == LazyPropertyInitializer.UNFETCHED_PROPERTY || target instanceof PersistentCollection && ((PersistentCollection)target).isWrapper(original) ? this.instantiateResult(original) : target;
        result = this.replaceElements(original, result, owner, copyCache, session);
        if (original == target) {
            boolean wasClean = target instanceof PersistentCollection && !((PersistentCollection)target).isDirty();
            this.replaceElements(result, target, owner, copyCache, session);
            if (wasClean) {
                ((PersistentCollection)target).clearDirty();
            }
            result = target;
        }
        return result;
    }

    public final Type getElementType(SessionFactoryImplementor factory) throws MappingException {
        return factory.getMappingMetamodel().getCollectionDescriptor(this.role).getElementType();
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getRole() + ")";
    }

    public Object getCollection(Object key, SharedSessionContractImplementor session, Object owner, Boolean overridingEager) {
        CollectionPersister persister = this.getPersister(session);
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        CollectionKey collectionKey = new CollectionKey(persister, key);
        PersistentCollection<?> collection = null;
        LoadingCollectionEntry loadingCollectionEntry = persistenceContext.getLoadContexts().findLoadingCollectionEntry(collectionKey);
        if (loadingCollectionEntry != null) {
            collection = loadingCollectionEntry.getCollectionInstance();
        }
        if (collection == null && (collection = persistenceContext.useUnownedCollection(collectionKey)) == null && (collection = persistenceContext.getCollection(collectionKey)) == null) {
            boolean eager;
            collection = this.instantiate(session, persister, key);
            collection.setOwner(owner);
            persistenceContext.addUninitializedCollection(persister, collection, key);
            boolean bl = overridingEager != null ? overridingEager : (eager = !persister.isLazy());
            if (this.initializeImmediately()) {
                session.initializeCollection(collection, false);
            } else if (eager) {
                persistenceContext.addNonLazyCollection(collection);
            }
            if (this.hasHolder()) {
                persistenceContext.addCollectionHolder(collection);
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracef("Created collection wrapper: %s", MessageHelper.collectionInfoString(persister, collection, key, session));
            }
            return collection.getValue();
        }
        collection.setOwner(owner);
        return collection.getValue();
    }

    public boolean hasHolder() {
        return false;
    }

    protected boolean initializeImmediately() {
        return false;
    }

    @Override
    public String getLHSPropertyName() {
        return this.foreignKeyPropertyName;
    }

    @Override
    public boolean isAlwaysDirtyChecked() {
        return true;
    }

    @Override
    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        return ArrayHelper.EMPTY_BOOLEAN_ARRAY;
    }
}

