/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.proton.ProtonHelper;
import io.vertx.proton.ProtonLink;
import io.vertx.proton.ProtonQoS;
import io.vertx.proton.impl.ProtonSessionImpl;
import java.util.Map;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.amqp.transport.Source;
import org.apache.qpid.proton.amqp.transport.Target;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Record;

abstract class ProtonLinkImpl<T extends ProtonLink<T>>
implements ProtonLink<T> {
    protected final Link link;
    private Handler<AsyncResult<T>> openHandler;
    private Handler<AsyncResult<T>> closeHandler;
    private Handler<AsyncResult<T>> detachHandler;

    ProtonLinkImpl(Link link) {
        this.link = link;
        this.link.setContext((Object)this);
        this.setQoS(this.getRemoteQoS());
    }

    protected abstract T self();

    @Override
    public ProtonSessionImpl getSession() {
        return (ProtonSessionImpl)this.link.getSession().getContext();
    }

    @Override
    public Record attachments() {
        return this.link.attachments();
    }

    @Override
    public ErrorCondition getCondition() {
        return this.link.getCondition();
    }

    @Override
    public int getCredit() {
        return this.link.getCredit();
    }

    @Override
    public boolean getDrain() {
        return this.link.getDrain();
    }

    public EndpointState getLocalState() {
        return this.link.getLocalState();
    }

    @Override
    public String getName() {
        return this.link.getName();
    }

    @Override
    public ErrorCondition getRemoteCondition() {
        return this.link.getRemoteCondition();
    }

    public int getRemoteCredit() {
        return this.link.getRemoteCredit();
    }

    public EndpointState getRemoteState() {
        return this.link.getRemoteState();
    }

    @Override
    public Target getRemoteTarget() {
        return this.link.getRemoteTarget();
    }

    @Override
    public Target getTarget() {
        return this.link.getTarget();
    }

    @Override
    public T setTarget(Target target) {
        this.link.setTarget(target);
        return this.self();
    }

    @Override
    public Source getRemoteSource() {
        return this.link.getRemoteSource();
    }

    @Override
    public Source getSource() {
        return this.link.getSource();
    }

    @Override
    public T setSource(Source source) {
        this.link.setSource(source);
        return this.self();
    }

    public int getUnsettled() {
        return this.link.getUnsettled();
    }

    @Override
    public int getQueued() {
        return this.link.getQueued();
    }

    public boolean advance() {
        return this.link.advance();
    }

    public int drained() {
        int drained = this.link.drained();
        this.getSession().getConnectionImpl().flush();
        return drained;
    }

    public boolean detached() {
        return this.link.detached();
    }

    public Delivery delivery(byte[] tag, int offset, int length) {
        return this.link.delivery(tag, offset, length);
    }

    public Delivery current() {
        return this.link.current();
    }

    @Override
    public T setCondition(ErrorCondition condition) {
        this.link.setCondition(condition);
        return this.self();
    }

    public Delivery delivery(byte[] tag) {
        return this.link.delivery(tag);
    }

    @Override
    public T open() {
        this.link.open();
        this.getSession().getConnectionImpl().flush();
        return this.self();
    }

    @Override
    public T close() {
        this.link.close();
        this.getSession().getConnectionImpl().flush();
        return this.self();
    }

    @Override
    public T detach() {
        this.link.detach();
        this.getSession().getConnectionImpl().flush();
        return this.self();
    }

    @Override
    public T openHandler(Handler<AsyncResult<T>> openHandler) {
        this.openHandler = openHandler;
        return this.self();
    }

    @Override
    public T closeHandler(Handler<AsyncResult<T>> closeHandler) {
        this.closeHandler = closeHandler;
        return this.self();
    }

    @Override
    public T detachHandler(Handler<AsyncResult<T>> detachHandler) {
        this.detachHandler = detachHandler;
        return this.self();
    }

    @Override
    public boolean isOpen() {
        return this.getLocalState() == EndpointState.ACTIVE;
    }

    @Override
    public ProtonQoS getQoS() {
        if (this.link.getSenderSettleMode() == SenderSettleMode.SETTLED) {
            return ProtonQoS.AT_MOST_ONCE;
        }
        return ProtonQoS.AT_LEAST_ONCE;
    }

    @Override
    public ProtonQoS getRemoteQoS() {
        if (this.link.getRemoteSenderSettleMode() == SenderSettleMode.SETTLED) {
            return ProtonQoS.AT_MOST_ONCE;
        }
        return ProtonQoS.AT_LEAST_ONCE;
    }

    @Override
    public T setQoS(ProtonQoS qos) {
        if (qos == null) {
            throw new IllegalArgumentException("Value must be specified");
        }
        switch (qos) {
            case AT_MOST_ONCE: {
                this.link.setSenderSettleMode(SenderSettleMode.SETTLED);
                this.link.setReceiverSettleMode(ReceiverSettleMode.FIRST);
                break;
            }
            case AT_LEAST_ONCE: {
                this.link.setSenderSettleMode(SenderSettleMode.UNSETTLED);
                this.link.setReceiverSettleMode(ReceiverSettleMode.FIRST);
            }
        }
        return this.self();
    }

    @Override
    public UnsignedLong getMaxMessageSize() {
        return this.link.getMaxMessageSize();
    }

    @Override
    public void setMaxMessageSize(UnsignedLong maxMessageSize) {
        this.link.setMaxMessageSize(maxMessageSize);
    }

    @Override
    public UnsignedLong getRemoteMaxMessageSize() {
        return this.link.getRemoteMaxMessageSize();
    }

    @Override
    public Map<Symbol, Object> getRemoteProperties() {
        return this.link.getRemoteProperties();
    }

    @Override
    public void setProperties(Map<Symbol, Object> properties) {
        this.link.setProperties(properties);
    }

    @Override
    public void setOfferedCapabilities(Symbol[] capabilities) {
        this.link.setOfferedCapabilities(capabilities);
    }

    @Override
    public Symbol[] getRemoteOfferedCapabilities() {
        return this.link.getRemoteOfferedCapabilities();
    }

    @Override
    public void setDesiredCapabilities(Symbol[] capabilities) {
        this.link.setDesiredCapabilities(capabilities);
    }

    @Override
    public Symbol[] getRemoteDesiredCapabilities() {
        return this.link.getRemoteDesiredCapabilities();
    }

    @Override
    public void free() {
        this.link.free();
        this.getSession().getConnectionImpl().flush();
    }

    void fireRemoteOpen() {
        if (this.openHandler != null) {
            this.openHandler.handle(ProtonHelper.future(this.self(), this.getRemoteCondition()));
        }
    }

    void fireRemoteDetach() {
        if (this.detachHandler != null) {
            this.detachHandler.handle(ProtonHelper.future(this.self(), this.getRemoteCondition()));
        }
    }

    void fireRemoteClose() {
        if (this.closeHandler != null) {
            this.closeHandler.handle(ProtonHelper.future(this.self(), this.getRemoteCondition()));
        }
    }

    abstract void handleLinkFlow();
}

