/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.impl;

import io.vertx.core.Handler;
import io.vertx.core.net.NetSocket;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.sasl.ProtonSaslAuthenticator;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Transport;

public class ProtonSaslServerAuthenticatorImpl
implements ProtonSaslAuthenticator {
    private Sasl sasl;
    private boolean succeeded;

    @Override
    public void init(NetSocket socket, ProtonConnection protonConnection, Transport transport) {
        this.sasl = transport.sasl();
        this.sasl.server();
        this.sasl.allowSkip(false);
        this.sasl.setMechanisms(new String[]{"ANONYMOUS"});
        this.succeeded = false;
    }

    @Override
    public void process(Handler<Boolean> completionHandler) {
        if (this.sasl == null) {
            throw new IllegalStateException("Init was not called with the associated transport");
        }
        boolean done = false;
        String[] remoteMechanisms = this.sasl.getRemoteMechanisms();
        if (remoteMechanisms.length > 0) {
            String chosen = remoteMechanisms[0];
            if ("ANONYMOUS".equals(chosen)) {
                this.sasl.done(Sasl.SaslOutcome.PN_SASL_OK);
                this.succeeded = true;
            } else {
                this.sasl.done(Sasl.SaslOutcome.PN_SASL_AUTH);
            }
            done = true;
        }
        completionHandler.handle((Object)done);
    }

    @Override
    public boolean succeeded() {
        return this.succeeded;
    }
}

