/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SetOfThrowables {
    public static final SetOfThrowables EMPTY = new SetOfThrowables(Collections.emptySet());
    public static final SetOfThrowables ALL = new SetOfThrowables(Collections.singleton(Throwable.class));
    private final Set<Class<? extends Throwable>> classes;

    public static SetOfThrowables create(Class<? extends Throwable> clazz) {
        return SetOfThrowables.create(Collections.singletonList(clazz));
    }

    public static SetOfThrowables create(Collection<Class<? extends Throwable>> classes) {
        HashSet<Class<? extends Throwable>> set = new HashSet<Class<? extends Throwable>>(classes);
        return new SetOfThrowables(set);
    }

    private SetOfThrowables(Set<Class<? extends Throwable>> classes) {
        this.classes = classes;
    }

    public boolean includes(Class<? extends Throwable> searchedFor) {
        for (Class<? extends Throwable> clazz : this.classes) {
            if (!clazz.isAssignableFrom(searchedFor)) continue;
            return true;
        }
        return false;
    }
}

