/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import javax.net.ssl.SSLContext;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.persistence.remote.configuration.AbstractSecurityConfigurationChildBuilder;
import org.infinispan.persistence.remote.configuration.KeyStoreConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.SecurityConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.SslConfiguration;
import org.infinispan.persistence.remote.configuration.TrustStoreConfigurationBuilder;

public class SslConfigurationBuilder
extends AbstractSecurityConfigurationChildBuilder
implements Builder<SslConfiguration> {
    private KeyStoreConfigurationBuilder keyStoreConfigurationBuilder;
    private TrustStoreConfigurationBuilder trustStoreConfigurationBuilder;

    SslConfigurationBuilder(SecurityConfigurationBuilder builder) {
        super(builder, SslConfiguration.attributeDefinitionSet());
        this.keyStoreConfigurationBuilder = new KeyStoreConfigurationBuilder(builder);
        this.trustStoreConfigurationBuilder = new TrustStoreConfigurationBuilder(builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public SslConfigurationBuilder disable() {
        this.attributes.attribute(SslConfiguration.ENABLED).set((Object)false);
        return this;
    }

    public SslConfigurationBuilder enable() {
        this.attributes.attribute(SslConfiguration.ENABLED).set((Object)true);
        return this;
    }

    public SslConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(SslConfiguration.ENABLED).set((Object)enabled);
        return this;
    }

    public SslConfigurationBuilder hostnameValidation(boolean validation) {
        this.attributes.attribute(SslConfiguration.HOSTNAME_VALIDATION).set((Object)validation);
        return this;
    }

    public SslConfigurationBuilder keyStoreFileName(String keyStoreFileName) {
        this.keyStoreConfigurationBuilder.keyStoreFileName(keyStoreFileName);
        return this;
    }

    public SslConfigurationBuilder keyStoreType(String keyStoreType) {
        this.keyStoreConfigurationBuilder.keyStoreType(keyStoreType);
        return this;
    }

    public SslConfigurationBuilder keyStorePassword(char[] keyStorePassword) {
        this.keyStoreConfigurationBuilder.keyStorePassword(keyStorePassword);
        return this;
    }

    public SslConfigurationBuilder keyStoreCertificatePassword(char[] keyStoreCertificatePassword) {
        this.keyStoreConfigurationBuilder.keyStoreCertificatePassword(keyStoreCertificatePassword);
        return this;
    }

    public SslConfigurationBuilder keyAlias(String keyAlias) {
        this.keyStoreConfigurationBuilder.keyAlias(keyAlias);
        return this;
    }

    public SslConfigurationBuilder sslContext(SSLContext sslContext) {
        this.attributes.attribute(SslConfiguration.SSL_CONTEXT).set((Object)sslContext);
        return this;
    }

    public SslConfigurationBuilder trustStoreFileName(String trustStoreFileName) {
        this.trustStoreConfigurationBuilder.trustStoreFileName(trustStoreFileName);
        return this;
    }

    public SslConfigurationBuilder trustStoreType(String trustStoreType) {
        this.trustStoreConfigurationBuilder.trustStoreType(trustStoreType);
        return this;
    }

    public SslConfigurationBuilder trustStorePassword(char[] trustStorePassword) {
        this.trustStoreConfigurationBuilder.trustStorePassword(trustStorePassword);
        return this;
    }

    public SslConfigurationBuilder sniHostName(String sniHostName) {
        this.attributes.attribute(SslConfiguration.SNI_HOSTNAME).set((Object)sniHostName);
        return this;
    }

    public SslConfigurationBuilder protocol(String protocol) {
        this.attributes.attribute(SslConfiguration.PROTOCOL).set((Object)protocol);
        return this;
    }

    public void validate() {
    }

    public SslConfiguration create() {
        return new SslConfiguration(this.attributes.protect(), this.keyStoreConfigurationBuilder.create(), this.trustStoreConfigurationBuilder.create());
    }

    public SslConfigurationBuilder read(SslConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.keyStoreConfigurationBuilder.read(template.keyStoreConfiguration(), combine);
        this.trustStoreConfigurationBuilder.read(template.trustStoreConfiguration(), combine);
        return this;
    }
}

