/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered.commandworkers;

import java.util.BitSet;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchResult;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.clustered.commandworkers.CQWorker;
import org.infinispan.query.dsl.embedded.impl.SearchQueryBuilder;
import org.infinispan.query.logging.Log;
import org.infinispan.search.mapper.common.EntityReference;

final class CQDelete
extends CQWorker {
    CQDelete() {
    }

    @Override
    CompletionStage<QueryResponse> perform(BitSet segments) {
        this.setFilter(segments);
        if (this.queryDefinition.getFirstResult() != 0 || this.queryDefinition.isCustomMaxResults()) {
            throw Log.CONTAINER.deleteStatementsCannotUsePaging();
        }
        SearchQueryBuilder query = this.queryDefinition.getSearchQueryBuilder();
        return this.blockingManager.supplyBlocking(() -> this.fetchReferences(query), (Object)this).thenApply(queryResult -> queryResult.hits().stream().map(ref -> this.cache.remove(ref.key()) != null ? 1 : 0).reduce(0, Integer::sum)).thenApply(QueryResponse::new);
    }

    private LuceneSearchResult<EntityReference> fetchReferences(SearchQueryBuilder query) {
        long start = this.queryStatistics.isEnabled() ? System.nanoTime() : 0L;
        LuceneSearchResult result = (LuceneSearchResult)query.entityReference().fetchAll();
        if (this.queryStatistics.isEnabled()) {
            this.queryStatistics.localIndexedQueryExecuted(this.queryDefinition.getQueryString(), System.nanoTime() - start);
        }
        return result;
    }
}

