/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.transactions;

import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.EmitterConfiguration;
import io.smallrye.reactive.messaging.EmitterFactory;
import io.smallrye.reactive.messaging.annotations.EmitterFactoryFor;
import io.smallrye.reactive.messaging.kafka.KafkaClientService;
import io.smallrye.reactive.messaging.kafka.transactions.KafkaTransactions;
import io.smallrye.reactive.messaging.kafka.transactions.KafkaTransactionsImpl;
import io.smallrye.reactive.messaging.providers.extension.ChannelProducer;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Channel;

@EmitterFactoryFor(value=KafkaTransactions.class)
@ApplicationScoped
public class KafkaTransactionsFactory
implements EmitterFactory<KafkaTransactionsImpl<Object>> {
    @Inject
    KafkaClientService kafkaClientService;
    @Inject
    ChannelRegistry channelRegistry;

    public KafkaTransactionsImpl<Object> createEmitter(EmitterConfiguration configuration, long defaultBufferSize) {
        return new KafkaTransactionsImpl<Object>(configuration, defaultBufferSize, this.kafkaClientService);
    }

    @Produces
    @Typed(value={KafkaTransactions.class})
    @Channel(value="")
    <T> KafkaTransactions<T> produceEmitter(InjectionPoint injectionPoint) {
        String channelName = ChannelProducer.getChannelName((InjectionPoint)injectionPoint);
        return (KafkaTransactions)this.channelRegistry.getEmitter(channelName, KafkaTransactions.class);
    }
}

