/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.telemetry.internals;

import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.telemetry.internals.MetricKey;
import org.apache.kafka.common.telemetry.internals.MetricKeyable;
import org.apache.kafka.shaded.io.opentelemetry.proto.common.v1.AnyValue;
import org.apache.kafka.shaded.io.opentelemetry.proto.common.v1.KeyValue;
import org.apache.kafka.shaded.io.opentelemetry.proto.metrics.v1.AggregationTemporality;
import org.apache.kafka.shaded.io.opentelemetry.proto.metrics.v1.Metric;
import org.apache.kafka.shaded.io.opentelemetry.proto.metrics.v1.NumberDataPoint;

public class SinglePointMetric
implements MetricKeyable {
    private final MetricKey key;
    private final Metric.Builder metricBuilder;

    private SinglePointMetric(MetricKey key, Metric.Builder metricBuilder) {
        this.key = key;
        this.metricBuilder = metricBuilder;
    }

    @Override
    public MetricKey key() {
        return this.key;
    }

    public Metric.Builder builder() {
        return this.metricBuilder;
    }

    public static SinglePointMetric gauge(MetricKey metricKey, Number value, Instant timestamp, Set<String> excludeLabels) {
        NumberDataPoint.Builder point = SinglePointMetric.point(timestamp, value);
        return SinglePointMetric.gauge(metricKey, point, excludeLabels);
    }

    public static SinglePointMetric gauge(MetricKey metricKey, double value, Instant timestamp, Set<String> excludeLabels) {
        NumberDataPoint.Builder point = SinglePointMetric.point(timestamp, value);
        return SinglePointMetric.gauge(metricKey, point, excludeLabels);
    }

    public static SinglePointMetric sum(MetricKey metricKey, double value, boolean monotonic, Instant timestamp, Set<String> excludeLabels) {
        return SinglePointMetric.sum(metricKey, value, monotonic, timestamp, null, excludeLabels);
    }

    public static SinglePointMetric sum(MetricKey metricKey, double value, boolean monotonic, Instant timestamp, Instant startTimestamp, Set<String> excludeLabels) {
        NumberDataPoint.Builder point = SinglePointMetric.point(timestamp, value);
        if (startTimestamp != null) {
            point.setStartTimeUnixNano(SinglePointMetric.toTimeUnixNanos(startTimestamp));
        }
        return SinglePointMetric.sum(metricKey, AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE, monotonic, point, excludeLabels);
    }

    public static SinglePointMetric deltaSum(MetricKey metricKey, double value, boolean monotonic, Instant timestamp, Instant startTimestamp, Set<String> excludeLabels) {
        NumberDataPoint.Builder point = SinglePointMetric.point(timestamp, value).setStartTimeUnixNano(SinglePointMetric.toTimeUnixNanos(startTimestamp));
        return SinglePointMetric.sum(metricKey, AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA, monotonic, point, excludeLabels);
    }

    private static SinglePointMetric sum(MetricKey metricKey, AggregationTemporality aggregationTemporality, boolean monotonic, NumberDataPoint.Builder point, Set<String> excludeLabels) {
        point.addAllAttributes(SinglePointMetric.asAttributes(metricKey.tags(), excludeLabels));
        Metric.Builder metric = Metric.newBuilder().setName(metricKey.name());
        metric.getSumBuilder().setAggregationTemporality(aggregationTemporality).setIsMonotonic(monotonic).addDataPoints(point);
        return new SinglePointMetric(metricKey, metric);
    }

    private static SinglePointMetric gauge(MetricKey metricKey, NumberDataPoint.Builder point, Set<String> excludeLabels) {
        point.addAllAttributes(SinglePointMetric.asAttributes(metricKey.tags(), excludeLabels));
        Metric.Builder metric = Metric.newBuilder().setName(metricKey.name());
        metric.getGaugeBuilder().addDataPoints(point);
        return new SinglePointMetric(metricKey, metric);
    }

    private static NumberDataPoint.Builder point(Instant timestamp, Number value) {
        if (value instanceof Long || value instanceof Integer) {
            return SinglePointMetric.point(timestamp, value.longValue());
        }
        return SinglePointMetric.point(timestamp, value.doubleValue());
    }

    private static NumberDataPoint.Builder point(Instant timestamp, long value) {
        return NumberDataPoint.newBuilder().setTimeUnixNano(SinglePointMetric.toTimeUnixNanos(timestamp)).setAsInt(value);
    }

    private static NumberDataPoint.Builder point(Instant timestamp, double value) {
        return NumberDataPoint.newBuilder().setTimeUnixNano(SinglePointMetric.toTimeUnixNanos(timestamp)).setAsDouble(value);
    }

    private static Iterable<KeyValue> asAttributes(Map<String, String> labels, Set<String> excludeLabels) {
        return labels.entrySet().stream().filter(entry -> !excludeLabels.contains(entry.getKey())).map(entry -> KeyValue.newBuilder().setKey((String)entry.getKey()).setValue(AnyValue.newBuilder().setStringValue((String)entry.getValue())).build())::iterator;
    }

    private static long toTimeUnixNanos(Instant t) {
        return TimeUnit.SECONDS.toNanos(t.getEpochSecond()) + (long)t.getNano();
    }
}

