/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import java.util.Iterator;
import java.util.Map;

final class ElasticsearchCommonMinimumShouldMatchConstraint {
    private final Integer matchingClausesNumber;
    private final Integer matchingClausesPercent;

    ElasticsearchCommonMinimumShouldMatchConstraint(Integer matchingClausesNumber, Integer matchingClausesPercent) {
        this.matchingClausesNumber = matchingClausesNumber;
        this.matchingClausesPercent = matchingClausesPercent;
    }

    static String formatMinimumShouldMatchConstraints(Map<Integer, ElasticsearchCommonMinimumShouldMatchConstraint> minimumShouldMatchConstraints) {
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<Integer, ElasticsearchCommonMinimumShouldMatchConstraint>> iterator = minimumShouldMatchConstraints.entrySet().iterator();
        Map.Entry<Integer, ElasticsearchCommonMinimumShouldMatchConstraint> entry = iterator.next();
        Integer ignoreConstraintCeiling = entry.getKey();
        ElasticsearchCommonMinimumShouldMatchConstraint constraint = entry.getValue();
        if (ignoreConstraintCeiling.equals(0) && minimumShouldMatchConstraints.size() == 1) {
            constraint.appendTo(builder, null);
            return builder.toString();
        }
        entry.getValue().appendTo(builder, ignoreConstraintCeiling);
        while (iterator.hasNext()) {
            entry = iterator.next();
            ignoreConstraintCeiling = entry.getKey();
            constraint = entry.getValue();
            builder.append(' ');
            constraint.appendTo(builder, ignoreConstraintCeiling);
        }
        return builder.toString();
    }

    void appendTo(StringBuilder builder, Integer ignoreConstraintCeiling) {
        if (ignoreConstraintCeiling != null) {
            builder.append(ignoreConstraintCeiling).append('<');
        }
        if (this.matchingClausesNumber != null) {
            builder.append(this.matchingClausesNumber);
        } else {
            builder.append(this.matchingClausesPercent).append('%');
        }
    }
}

