/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.impl;

import java.util.Optional;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.impl.ConfigurationPropertySourceExtractor;
import org.hibernate.search.engine.cfg.impl.ConfigurationPropertySourceScopeUtils;

public final class EngineConfigurationUtils {
    private EngineConfigurationUtils() {
    }

    public static ConfigurationPropertySourceExtractor extractorForBackend(Optional<String> backendNameOptional) {
        if (!backendNameOptional.isPresent()) {
            return (beanResolver, engineSource) -> engineSource.withMask("backend").withFallback(ConfigurationPropertySourceScopeUtils.fallback(beanResolver, ConfigurationPropertySourceScopeUtils.backend()));
        }
        return (beanResolver, engineSource) -> engineSource.withMask("backends").withMask((String)backendNameOptional.get()).withFallback(ConfigurationPropertySourceScopeUtils.fallback(beanResolver, ConfigurationPropertySourceScopeUtils.backend((String)backendNameOptional.get())));
    }

    public static ConfigurationPropertySourceExtractor extractorForIndex(ConfigurationPropertySourceExtractor extractorForBackend, String backendName, String indexName) {
        return (beanResolver, engineSource) -> {
            ConfigurationPropertySource backendSource = extractorForBackend.extract(beanResolver, engineSource);
            return backendSource.withMask("indexes").withMask(indexName).withFallback(ConfigurationPropertySourceScopeUtils.fallback(beanResolver, ConfigurationPropertySourceScopeUtils.index(backendName, indexName))).withFallback(backendSource);
        };
    }
}

