/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.workmanager;

import org.jboss.as.threads.ManagedJBossThreadPoolExecutorService;
import org.jboss.as.threads.ManagedQueueExecutorService;
import org.jboss.as.threads.ManagedQueuelessExecutorService;
import org.jboss.as.threads.ManagedScheduledExecutorService;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.workmanager.StatisticsExecutor;
import org.jboss.logging.Logger;
import org.jboss.threads.BlockingExecutor;
import org.jboss.threads.JBossThreadPoolExecutor;
import org.jboss.threads.management.ThreadPoolExecutorMBean;

public class StatisticsExecutorImpl
implements StatisticsExecutor {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)org.jboss.jca.core.workmanager.StatisticsExecutorImpl.class.getName());
    private final BlockingExecutor realExecutor;

    public StatisticsExecutorImpl(BlockingExecutor realExecutor) {
        this.realExecutor = realExecutor;
    }

    public void execute(Runnable runnable) {
        this.realExecutor.execute(runnable);
    }

    public long getNumberOfFreeThreads() {
        if (this.realExecutor instanceof JBossThreadPoolExecutor) {
            return (long)((JBossThreadPoolExecutor)this.realExecutor).getMaximumPoolSize() - (long)((JBossThreadPoolExecutor)this.realExecutor).getActiveCount();
        }
        if (this.realExecutor instanceof ThreadPoolExecutorMBean) {
            return (long)((ThreadPoolExecutorMBean)this.realExecutor).getMaxThreads() - (long)((ThreadPoolExecutorMBean)this.realExecutor).getCurrentThreadCount();
        }
        if (this.realExecutor instanceof ManagedQueueExecutorService) {
            return (long)((ManagedQueueExecutorService)this.realExecutor).getMaxThreads() - (long)((ManagedQueueExecutorService)this.realExecutor).getCurrentThreadCount();
        }
        if (this.realExecutor instanceof ManagedJBossThreadPoolExecutorService) {
            return (long)((ManagedJBossThreadPoolExecutorService)this.realExecutor).getMaxThreads() - (long)((ManagedJBossThreadPoolExecutorService)this.realExecutor).getCurrentThreadCount();
        }
        if (this.realExecutor instanceof ManagedQueuelessExecutorService) {
            return (long)((ManagedQueuelessExecutorService)this.realExecutor).getMaxThreads() - (long)((ManagedQueuelessExecutorService)this.realExecutor).getCurrentThreadCount();
        }
        if (this.realExecutor instanceof ManagedScheduledExecutorService) {
            return (long)((ManagedScheduledExecutorService)this.realExecutor).getLargestPoolSize() - (long)((ManagedScheduledExecutorService)this.realExecutor).getActiveCount();
        }
        return 0L;
    }
}

