/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Predicate;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationAddressPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationQueuePolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.ActiveMQServerAMQPFederationPlugin;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromAddressPolicy;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromQueuePolicy;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationAddressPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationInternal;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationQueuePolicyManager;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.qpid.proton.engine.Link;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMQPFederation
implements FederationInternal {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String FEDERATION_INSTANCE_RECORD = "FEDERATION_INSTANCE_RECORD";
    private static final WildcardConfiguration DEFAULT_WILDCARD_CONFIGURATION = new WildcardConfiguration();
    protected final Map<String, FederationQueuePolicyManager> queueMatchPolicies = new ConcurrentHashMap<String, FederationQueuePolicyManager>();
    protected final Map<String, FederationAddressPolicyManager> addressMatchPolicies = new ConcurrentHashMap<String, FederationAddressPolicyManager>();
    protected final Map<String, Predicate<Link>> linkClosedinterceptors = new ConcurrentHashMap<String, Predicate<Link>>();
    protected final WildcardConfiguration wildcardConfiguration;
    protected final ScheduledExecutorService scheduler;
    protected final String name;
    protected final ActiveMQServer server;
    protected volatile AMQPConnectionContext connection;
    protected volatile AMQPSessionContext session;
    protected boolean started;
    protected volatile boolean connected;

    public AMQPFederation(String name, ActiveMQServer server) {
        Objects.requireNonNull(name, "Federation name cannot be null");
        Objects.requireNonNull(server, "Provided server instance cannot be null");
        this.name = name;
        this.server = server;
        this.scheduler = server.getScheduledPool();
        this.wildcardConfiguration = server.getConfiguration().getWildcardConfiguration() != null ? server.getConfiguration().getWildcardConfiguration() : DEFAULT_WILDCARD_CONFIGURATION;
    }

    public WildcardConfiguration getWildcardConfiguration() {
        return this.wildcardConfiguration;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @Override
    public ActiveMQServer getServer() {
        return this.server;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized boolean isStarted() {
        return this.started;
    }

    public abstract AMQPConnectionContext getConnectionContext();

    public abstract AMQPSessionContext getSessionContext();

    public abstract int getLinkAttachTimeout();

    public abstract int getReceiverCredits();

    public abstract int getReceiverCreditsLow();

    public abstract int getLargeMessageThreshold();

    public abstract boolean isCoreMessageTunnelingEnabled();

    @Override
    public final synchronized void start() throws ActiveMQException {
        if (!this.started) {
            this.handleFederationStarted();
            this.signalFederationStarted();
            this.started = true;
        }
    }

    @Override
    public final synchronized void stop() throws ActiveMQException {
        if (this.started) {
            this.handleFederationStopped();
            this.signalFederationStopped();
            this.started = false;
        }
    }

    public AMQPFederation addLinkClosedInterceptor(String id, Predicate<Link> interceptor) {
        this.linkClosedinterceptors.put(id, interceptor);
        return this;
    }

    public AMQPFederation removeLinkClosedInterceptor(String id) {
        this.linkClosedinterceptors.remove(id);
        return this;
    }

    public synchronized AMQPFederation addQueueMatchPolicy(FederationReceiveFromQueuePolicy queuePolicy) throws ActiveMQException {
        AMQPFederationQueuePolicyManager manager = new AMQPFederationQueuePolicyManager(this, queuePolicy);
        this.queueMatchPolicies.put(queuePolicy.getPolicyName(), manager);
        logger.debug("AMQP Federation {} adding queue match policy: {}", (Object)this.getName(), (Object)queuePolicy.getPolicyName());
        if (this.isStarted()) {
            this.scheduler.execute(() -> manager.start());
        }
        return this;
    }

    public synchronized AMQPFederation addAddressMatchPolicy(FederationReceiveFromAddressPolicy addressPolicy) throws ActiveMQException {
        AMQPFederationAddressPolicyManager manager = new AMQPFederationAddressPolicyManager(this, addressPolicy);
        this.addressMatchPolicies.put(addressPolicy.getPolicyName(), manager);
        logger.debug("AMQP Federation {} adding address match policy: {}", (Object)this.getName(), (Object)addressPolicy.getPolicyName());
        if (this.isStarted()) {
            this.scheduler.execute(() -> manager.start());
        }
        return this;
    }

    protected abstract void signalResourceCreateError(Exception var1);

    protected abstract void signalError(Exception var1);

    protected void handleFederationStarted() throws ActiveMQException {
        if (this.connected) {
            this.queueMatchPolicies.forEach((k, v) -> v.start());
            this.addressMatchPolicies.forEach((k, v) -> v.start());
        }
    }

    protected void handleFederationStopped() throws ActiveMQException {
        this.queueMatchPolicies.forEach((k, v) -> v.stop());
        this.addressMatchPolicies.forEach((k, v) -> v.stop());
    }

    protected boolean invokeLinkClosedInterceptors(Link link) {
        for (Map.Entry<String, Predicate<Link>> interceptor : this.linkClosedinterceptors.entrySet()) {
            if (!interceptor.getValue().test(link)) continue;
            logger.trace("Remote link[{}] close intercepted and handled by interceptor: {}", (Object)link.getName(), (Object)interceptor.getKey());
            return true;
        }
        return false;
    }

    protected void signalFederationStarted() {
        try {
            this.server.callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin) {
                    ((ActiveMQServerAMQPFederationPlugin)plugin).federationStarted(this);
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("federationStarted", (Throwable)t);
        }
    }

    protected void signalFederationStopped() {
        try {
            this.server.callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin) {
                    ((ActiveMQServerAMQPFederationPlugin)plugin).federationStopped(this);
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("federationStopped", (Throwable)t);
        }
    }
}

