/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederation;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConstants;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumerConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.ActiveMQServerAMQPFederationPlugin;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPNotFoundException;
import org.apache.activemq.artemis.protocol.amqp.federation.Federation;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromQueuePolicy;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationConsumerInternal;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPTunneledCoreLargeMessageReader;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPTunneledCoreMessageReader;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpJmsSelectorFilter;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.MessageReader;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerReceiverContext;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPFederationQueueConsumer
implements FederationConsumerInternal {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int DEFAULT_PULL_CREDIT_BATCH_SIZE = 100;
    public static final int DEFAULT_PENDING_MSG_CHECK_BACKOFF_MULTIPLIER = 2;
    public static final int DEFAULT_PENDING_MSG_CHECK_MAX_DELAY = 30;
    private static final Symbol[] DEFAULT_OUTCOMES = new Symbol[]{Accepted.DESCRIPTOR_SYMBOL, Rejected.DESCRIPTOR_SYMBOL, Released.DESCRIPTOR_SYMBOL, Modified.DESCRIPTOR_SYMBOL};
    private final AMQPFederation federation;
    private final AMQPFederationConsumerConfiguration configuration;
    private final FederationConsumerInfo consumerInfo;
    private final FederationReceiveFromQueuePolicy policy;
    private final AMQPConnectionContext connection;
    private final AMQPSessionContext session;
    private final Predicate<Link> remoteCloseIntercepter = this::remoteLinkClosedIntercepter;
    private final Transformer transformer;
    private AMQPFederatedQueueDeliveryReceiver receiver;
    private Receiver protonReceiver;
    private boolean started;
    private volatile boolean closed;
    private Consumer<FederationConsumerInternal> remoteCloseHandler;

    public AMQPFederationQueueConsumer(AMQPFederation federation, AMQPFederationConsumerConfiguration configuration, AMQPSessionContext session, FederationConsumerInfo consumerInfo, FederationReceiveFromQueuePolicy policy) {
        this.federation = federation;
        this.consumerInfo = consumerInfo;
        this.policy = policy;
        this.connection = session.getAMQPConnectionContext();
        this.session = session;
        this.configuration = configuration;
        TransformerConfiguration transformerConfiguration = policy.getTransformerConfiguration();
        this.transformer = transformerConfiguration != null ? federation.getServer().getServiceRegistry().getFederationTransformer(policy.getPolicyName(), transformerConfiguration) : m -> m;
    }

    @Override
    public Federation getFederation() {
        return this.federation;
    }

    @Override
    public FederationConsumerInfo getConsumerInfo() {
        return this.consumerInfo;
    }

    public FederationReceiveFromQueuePolicy getPolicy() {
        return this.policy;
    }

    @Override
    public synchronized void start() {
        if (!this.started && !this.closed) {
            this.started = true;
            this.asyncCreateReceiver();
        }
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.started) {
                this.started = false;
                this.connection.runLater(() -> {
                    this.federation.removeLinkClosedInterceptor(this.consumerInfo.getFqqn());
                    if (this.receiver != null) {
                        try {
                            this.receiver.close(false);
                        }
                        catch (ActiveMQAMQPException activeMQAMQPException) {
                        }
                        finally {
                            this.receiver = null;
                        }
                    }
                    if (this.protonReceiver != null) {
                        try {
                            this.protonReceiver.close();
                        }
                        finally {
                            this.protonReceiver = null;
                        }
                    }
                    this.connection.flush();
                });
            }
        }
    }

    @Override
    public synchronized AMQPFederationQueueConsumer setRemoteClosedHandler(Consumer<FederationConsumerInternal> handler) {
        if (this.started) {
            throw new IllegalStateException("Cannot set a remote close handler after the consumer is started");
        }
        this.remoteCloseHandler = handler;
        return this;
    }

    protected boolean remoteLinkClosedIntercepter(Link link) {
        if (link == this.protonReceiver && link.getRemoteCondition() != null && link.getRemoteCondition().getCondition() != null) {
            Symbol errorCondition = link.getRemoteCondition().getCondition();
            if (AmqpSupport.RESOURCE_DELETED.equals(errorCondition)) {
                return true;
            }
            if (AmqpSupport.NOT_FOUND.equals(errorCondition)) {
                return true;
            }
            if (AmqpSupport.DETACH_FORCED.equals(errorCondition)) {
                return true;
            }
        }
        return false;
    }

    private void signalBeforeFederationConsumerMessageHandled(Message message) throws ActiveMQException {
        try {
            this.federation.getServer().callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin) {
                    ((ActiveMQServerAMQPFederationPlugin)plugin).beforeFederationConsumerMessageHandled(this, message);
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("beforeFederationConsumerMessageHandled", (Throwable)t);
        }
    }

    private void signalAfterFederationConsumerMessageHandled(Message message) throws ActiveMQException {
        try {
            this.federation.getServer().callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin) {
                    ((ActiveMQServerAMQPFederationPlugin)plugin).afterFederationConsumerMessageHandled(this, message);
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("afterFederationConsumerMessageHandled", (Throwable)t);
        }
    }

    private String generateLinkName() {
        return "federation-" + this.federation.getName() + "-queue-receiver-" + this.consumerInfo.getFqqn() + "-" + this.federation.getServer().getNodeID();
    }

    private void asyncCreateReceiver() {
        this.connection.runLater(() -> {
            if (this.closed) {
                return;
            }
            try {
                Receiver protonReceiver = this.session.getSession().receiver(this.generateLinkName());
                Target target = new Target();
                Source source = new Source();
                String address = this.consumerInfo.getFqqn();
                Queue localQueue = this.federation.getServer().locateQueue(this.consumerInfo.getQueueName());
                if (RoutingType.ANYCAST.equals((Object)this.consumerInfo.getRoutingType())) {
                    source.setCapabilities(new Symbol[]{AmqpSupport.QUEUE_CAPABILITY});
                } else {
                    source.setCapabilities(new Symbol[]{AmqpSupport.TOPIC_CAPABILITY});
                }
                source.setOutcomes(Arrays.copyOf(DEFAULT_OUTCOMES, DEFAULT_OUTCOMES.length));
                source.setDurable(TerminusDurability.NONE);
                source.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
                source.setAddress(address);
                if (this.consumerInfo.getFilterString() != null && !this.consumerInfo.getFilterString().isEmpty()) {
                    AmqpJmsSelectorFilter jmsFilter = new AmqpJmsSelectorFilter(this.consumerInfo.getFilterString());
                    HashMap<Symbol, AmqpJmsSelectorFilter> filtersMap = new HashMap<Symbol, AmqpJmsSelectorFilter>();
                    filtersMap.put(AmqpSupport.JMS_SELECTOR_KEY, jmsFilter);
                    source.setFilter(filtersMap);
                }
                target.setAddress(address);
                HashMap<Symbol, Integer> receiverProperties = new HashMap<Symbol, Integer>();
                receiverProperties.put(AMQPFederationConstants.FEDERATION_RECEIVER_PRIORITY, this.consumerInfo.getPriority());
                protonReceiver.setSenderSettleMode(SenderSettleMode.UNSETTLED);
                protonReceiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
                protonReceiver.setDesiredCapabilities(new Symbol[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER});
                if (this.configuration.isCoreMessageTunnelingEnabled()) {
                    protonReceiver.setOfferedCapabilities(new Symbol[]{AmqpSupport.CORE_MESSAGE_TUNNELING_SUPPORT});
                }
                protonReceiver.setProperties(receiverProperties);
                protonReceiver.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
                protonReceiver.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
                protonReceiver.open();
                AtomicBoolean openTimedOut = new AtomicBoolean(false);
                ScheduledFuture<?> openTimeoutTask = this.federation.getLinkAttachTimeout() > 0 ? this.federation.getServer().getScheduledPool().schedule(() -> {
                    openTimedOut.set(true);
                    this.federation.signalResourceCreateError((Exception)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.brokerConnectionTimeout()));
                }, (long)this.federation.getLinkAttachTimeout(), TimeUnit.SECONDS) : null;
                this.protonReceiver = protonReceiver;
                protonReceiver.attachments().set(AmqpSupport.AMQP_LINK_INITIALIZER_KEY, Runnable.class, () -> {
                    try {
                        if (openTimeoutTask != null) {
                            openTimeoutTask.cancel(false);
                        }
                        if (openTimedOut.get()) {
                            return;
                        }
                        if (protonReceiver.getRemoteSource() != null && !AmqpSupport.verifyOfferedCapabilities((Link)protonReceiver, AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER)) {
                            this.federation.signalResourceCreateError((Exception)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.missingOfferedCapability(AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER.toString())));
                            return;
                        }
                        this.federation.addLinkClosedInterceptor(this.consumerInfo.getFqqn(), this.remoteCloseIntercepter);
                        this.receiver = new AMQPFederatedQueueDeliveryReceiver(localQueue, protonReceiver);
                        if (protonReceiver.getRemoteSource() != null) {
                            logger.debug("AMQP Federation {} queue consumer {} completed open", (Object)this.federation.getName(), (Object)this.consumerInfo);
                        } else {
                            logger.debug("AMQP Federation {} queue consumer {} rejected by remote", (Object)this.federation.getName(), (Object)this.consumerInfo);
                        }
                        this.session.addReceiver(protonReceiver, (session, protonRcvr) -> this.receiver);
                    }
                    catch (Exception e) {
                        this.federation.signalError(e);
                    }
                });
            }
            catch (Exception e) {
                this.federation.signalError(e);
            }
            this.connection.flush();
        });
    }

    private static int caclulateNextDelay(int lastDelay, int backoffMultiplier, int maxDelay) {
        int nextDelay = lastDelay == 0 ? 1 : Math.min(lastDelay * backoffMultiplier, maxDelay);
        return nextDelay;
    }

    private class AMQPFederatedQueueDeliveryReceiver
    extends ProtonServerReceiverContext {
        private final SimpleString cachedFqqn;
        private final Queue localQueue;
        private MessageReader coreMessageReader;
        private MessageReader coreLargeMessageReader;
        private final AtomicBoolean creditTopUpInProgress;
        private final Runnable checkForNoBacklogRunnable;
        private final Runnable performCreditTopUpRunnable;
        private int lastBacklogCheckDelay;

        AMQPFederatedQueueDeliveryReceiver(Queue localQueue, Receiver receiver) {
            super(AMQPFederationQueueConsumer.this.session.getSessionSPI(), AMQPFederationQueueConsumer.this.session.getAMQPConnectionContext(), AMQPFederationQueueConsumer.this.session, receiver);
            this.creditTopUpInProgress = new AtomicBoolean();
            this.checkForNoBacklogRunnable = this::checkForNoBacklogOnQueue;
            this.performCreditTopUpRunnable = this::performCreditTopUp;
            this.localQueue = localQueue;
            this.cachedFqqn = SimpleString.toSimpleString((String)AMQPFederationQueueConsumer.this.consumerInfo.getFqqn());
        }

        @Override
        public void close(boolean remoteLinkClose) throws ActiveMQAMQPException {
            super.close(remoteLinkClose);
            if (remoteLinkClose && AMQPFederationQueueConsumer.this.remoteCloseHandler != null) {
                try {
                    AMQPFederationQueueConsumer.this.remoteCloseHandler.accept(AMQPFederationQueueConsumer.this);
                }
                catch (Exception e) {
                    logger.debug("User remote closed handler threw error: ", (Throwable)e);
                }
                finally {
                    AMQPFederationQueueConsumer.this.remoteCloseHandler = null;
                }
            }
        }

        @Override
        public void initialize() throws Exception {
            this.initialized = true;
            Target target = (Target)this.receiver.getRemoteTarget();
            this.receiver.setSenderSettleMode(this.receiver.getRemoteSenderSettleMode());
            this.receiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
            if (target == null || target.getAddress() == null || target.getAddress().isEmpty()) {
                throw new ActiveMQAMQPInternalErrorException("Remote should have sent an valid Target but we got: " + target);
            }
            this.address = SimpleString.toSimpleString((String)target.getAddress());
            this.defRoutingType = this.getRoutingType(target.getCapabilities(), this.address);
            try {
                QueueQueryResult result = this.sessionSPI.queueQuery(this.address, this.defRoutingType, false);
                if (!result.isExists()) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.addressDoesntExist(this.address.toString());
                }
            }
            catch (ActiveMQAMQPNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
            }
            this.flow();
        }

        @Override
        protected MessageReader trySelectMessageReader(Receiver receiver, Delivery delivery) {
            if (delivery.getMessageFormat() == 1183580416) {
                return this.coreMessageReader != null ? this.coreMessageReader : (this.coreMessageReader = new AMQPTunneledCoreMessageReader(this));
            }
            if (delivery.getMessageFormat() == 1183580672) {
                return this.coreLargeMessageReader != null ? this.coreLargeMessageReader : (this.coreLargeMessageReader = new AMQPTunneledCoreLargeMessageReader(this));
            }
            return super.trySelectMessageReader(receiver, delivery);
        }

        @Override
        protected void actualDelivery(Message message, Delivery delivery, DeliveryAnnotations deliveryAnnotations, Receiver receiver, Transaction tx) {
            try {
                Message theMessage;
                if (logger.isTraceEnabled()) {
                    logger.trace("AMQP Federation {} queue consumer {} dispatching incoming message: {}", new Object[]{AMQPFederationQueueConsumer.this.federation.getName(), AMQPFederationQueueConsumer.this.consumerInfo, message});
                }
                if ((theMessage = AMQPFederationQueueConsumer.this.transformer.transform(message)) != message && logger.isTraceEnabled()) {
                    logger.trace("The transformer {} replaced the original message {} with a new instance {}", new Object[]{AMQPFederationQueueConsumer.this.transformer, message, theMessage});
                }
                AMQPFederationQueueConsumer.this.signalBeforeFederationConsumerMessageHandled(theMessage);
                this.sessionSPI.serverSend(this, tx, receiver, delivery, this.cachedFqqn, this.routingContext, theMessage);
                AMQPFederationQueueConsumer.this.signalAfterFederationConsumerMessageHandled(theMessage);
            }
            catch (Exception e) {
                logger.warn("Inbound delivery for {} encountered an error: {}", new Object[]{AMQPFederationQueueConsumer.this.consumerInfo, e.getMessage(), e});
                this.deliveryFailed(delivery, receiver, e);
            }
        }

        @Override
        protected Runnable createCreditRunnable(AMQPConnectionContext connection) {
            if (AMQPFederationQueueConsumer.this.federation.getReceiverCredits() > 0) {
                return AMQPFederatedQueueDeliveryReceiver.createCreditRunnable(AMQPFederationQueueConsumer.this.configuration.getReceiverCredits(), AMQPFederationQueueConsumer.this.configuration.getReceiverCreditsLow(), this.receiver, connection, this);
            }
            return this::checkIfCreditTopUpNeeded;
        }

        @Override
        protected int getConfiguredMinLargeMessageSize(AMQPConnectionContext connection) {
            return AMQPFederationQueueConsumer.this.configuration.getLargeMessageThreshold();
        }

        private void checkIfCreditTopUpNeeded() {
            if (!this.connection.isHandler()) {
                this.connection.runLater(this.creditRunnable);
                return;
            }
            if (this.receiver.getCredit() + this.pendingSettles <= 0 && !this.creditTopUpInProgress.get()) {
                this.creditTopUpInProgress.set(true);
                this.localQueue.getExecutor().execute(this.checkForNoBacklogRunnable);
            }
        }

        private void checkForNoBacklogOnQueue() {
            if (this.localQueue.getPendingMessageCount() == 0L) {
                this.lastBacklogCheckDelay = 0;
                this.connection.runLater(this.performCreditTopUpRunnable);
            } else {
                this.lastBacklogCheckDelay = AMQPFederationQueueConsumer.caclulateNextDelay(this.lastBacklogCheckDelay, 2, 30);
                AMQPFederationQueueConsumer.this.federation.getScheduler().schedule(() -> this.localQueue.getExecutor().execute(this.checkForNoBacklogRunnable), (long)this.lastBacklogCheckDelay, TimeUnit.SECONDS);
            }
        }

        private void performCreditTopUp() {
            this.connection.requireInHandler();
            if (this.receiver.getLocalState() != EndpointState.ACTIVE) {
                return;
            }
            this.receiver.flow(100);
            this.connection.instantFlush();
            this.lastBacklogCheckDelay = 0;
            this.creditTopUpInProgress.set(false);
        }
    }
}

