/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPLargeMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.proton.MessageReader;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonAbstractReceiver;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;

public class AMQPLargeMessageReader
implements MessageReader {
    private final ProtonAbstractReceiver serverReceiver;
    private AMQPLargeMessage currentMessage;
    private DeliveryAnnotations deliveryAnnotations;
    private boolean closed = true;

    public AMQPLargeMessageReader(ProtonAbstractReceiver serverReceiver) {
        this.serverReceiver = serverReceiver;
    }

    @Override
    public DeliveryAnnotations getDeliveryAnnotations() {
        return this.deliveryAnnotations;
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.currentMessage != null) {
                try {
                    this.currentMessage.deleteFile();
                }
                catch (Throwable error) {
                    ActiveMQServerLogger.LOGGER.errorDeletingLargeMessageFile(error);
                }
                finally {
                    this.currentMessage = null;
                }
            }
            this.deliveryAnnotations = null;
            this.closed = true;
        }
    }

    @Override
    public AMQPLargeMessageReader open() {
        if (!this.closed) {
            throw new IllegalStateException("Reader was not closed before call to open.");
        }
        this.closed = false;
        return this;
    }

    @Override
    public Message readBytes(Delivery delivery) throws Exception {
        AMQPLargeMessage result;
        if (this.closed) {
            throw new IllegalStateException("AMQP Large Message Reader is closed and read cannot proceed");
        }
        Receiver receiver = (Receiver)delivery.getLink();
        ReadableBuffer dataBuffer = receiver.recv();
        if (this.currentMessage == null) {
            AMQPSessionCallback sessionSPI = this.serverReceiver.getSessionContext().getSessionSPI();
            long id = sessionSPI.getStorageManager().generateID();
            this.currentMessage = new AMQPLargeMessage(id, delivery.getMessageFormat(), null, sessionSPI.getCoreMessageObjectPools(), sessionSPI.getStorageManager());
            this.currentMessage.parseHeader(dataBuffer);
            sessionSPI.getStorageManager().largeMessageCreated(id, (LargeServerMessage)this.currentMessage);
        }
        this.currentMessage.addBytes(dataBuffer);
        if (!delivery.isPartial()) {
            this.currentMessage.releaseResources(this.serverReceiver.getConnection().isLargeMessageSync(), true);
            result = this.currentMessage;
            this.currentMessage = null;
            this.deliveryAnnotations = result.getDeliveryAnnotations();
        } else {
            result = null;
        }
        return result;
    }
}

