/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.discovery;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.impl.StaticDiscoveryProvider;
import org.wildfly.extension.discovery.DiscoveryProviderRegistrar;
import org.wildfly.extension.discovery.DiscoverySubsystemRegistrar;
import org.wildfly.extension.discovery.Messages;
import org.wildfly.extension.discovery.ServiceURIValidator;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class StaticDiscoveryProviderRegistrar
extends DiscoveryProviderRegistrar {
    static final PathElement PATH = PathElement.pathElement((String)"static-provider");
    private static final SimpleAttributeDefinition ABSTRACT_TYPE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("abstract-type", ModelType.STRING, true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition ABSTRACT_TYPE_AUTHORITY = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("abstract-type-authority", ModelType.STRING, true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition URI = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("uri", ModelType.STRING, false).setValidator((ParameterValidator)new ServiceURIValidator())).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition URI_SCHEME_AUTHORITY = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("uri-scheme-authority", ModelType.STRING, true).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, false).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition VALUE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("value", ModelType.STRING, true).setAllowExpression(true)).build();
    private static final ObjectTypeAttributeDefinition ATTRIBUTE = new ObjectTypeAttributeDefinition.Builder("attribute", new AttributeDefinition[]{NAME, VALUE}).build();
    private static final ObjectListAttributeDefinition SERVICE_ATTRIBUTES = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("attributes", ATTRIBUTE).setAttributeMarshaller(AttributeMarshaller.UNWRAPPED_OBJECT_LIST_MARSHALLER)).setAttributeParser(AttributeParser.UNWRAPPED_OBJECT_LIST_PARSER)).setRequired(false)).build();
    private static final ObjectTypeAttributeDefinition SERVICE = new ObjectTypeAttributeDefinition.Builder("service", new AttributeDefinition[]{ABSTRACT_TYPE, ABSTRACT_TYPE_AUTHORITY, URI, URI_SCHEME_AUTHORITY, SERVICE_ATTRIBUTES}).build();
    private static final ObjectListAttributeDefinition SERVICES = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("services", SERVICE).setAttributeMarshaller(AttributeMarshaller.UNWRAPPED_OBJECT_LIST_MARSHALLER)).setAttributeParser(AttributeParser.UNWRAPPED_OBJECT_LIST_PARSER)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final Collection<AttributeDefinition> ATTRIBUTES = List.of(SERVICES);

    StaticDiscoveryProviderRegistrar() {
        super(PATH, (ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)DiscoverySubsystemRegistrar.RESOLVER.createChildResolver(PATH)).addAttributes(ATTRIBUTES));
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        List services = SERVICES.resolveModelAttribute(context, model).asListOrEmpty();
        ArrayList<ServiceURL> serviceURLs = new ArrayList<ServiceURL>(services.size());
        for (ModelNode service : services) {
            String uriSchemeAuthority;
            String abstractTypeAuthority;
            ServiceURL.Builder builder = new ServiceURL.Builder();
            builder.setUri(java.net.URI.create(URI.resolveModelAttribute(context, service).asString()));
            String abstractType = ABSTRACT_TYPE.resolveModelAttribute(context, service).asStringOrNull();
            if (abstractType != null) {
                builder.setAbstractType(abstractType);
            }
            if ((abstractTypeAuthority = ABSTRACT_TYPE_AUTHORITY.resolveModelAttribute(context, service).asStringOrNull()) != null) {
                builder.setAbstractTypeAuthority(abstractTypeAuthority);
            }
            if ((uriSchemeAuthority = URI_SCHEME_AUTHORITY.resolveModelAttribute(context, service).asStringOrNull()) != null) {
                builder.setUriSchemeAuthority(uriSchemeAuthority);
            }
            for (ModelNode attribute : SERVICE_ATTRIBUTES.resolveModelAttribute(context, service).asListOrEmpty()) {
                String name = NAME.resolveModelAttribute(context, attribute).asString();
                String value = VALUE.resolveModelAttribute(context, attribute).asStringOrNull();
                if (value != null) {
                    builder.addAttribute(name, AttributeValue.fromString((String)value));
                    continue;
                }
                builder.addAttribute(name);
            }
            ServiceURL serviceURL = builder.create();
            Messages.log.tracef("Adding service URL %s", serviceURL);
            serviceURLs.add(serviceURL);
        }
        return (ResourceServiceInstaller)CapabilityServiceInstaller.builder(DiscoveryProviderRegistrar.DISCOVERY_PROVIDER_CAPABILITY, (Object)new StaticDiscoveryProvider(serviceURLs)).build();
    }
}

