/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.ra.ActiveMQRAMessageProducer;
import org.apache.activemq.artemis.ra.ActiveMQRASession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQRATopicPublisher
extends ActiveMQRAMessageProducer
implements TopicPublisher {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ActiveMQRATopicPublisher(TopicPublisher producer, ActiveMQRASession session) {
        super((MessageProducer)producer, session);
        logger.trace("constructor({}, {})", (Object)producer, (Object)session);
    }

    public Topic getTopic() throws JMSException {
        logger.trace("getTopic()");
        return ((TopicPublisher)this.producer).getTopic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.lock();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("send {} message={} deliveryMode={} priority={} ttl={}", new Object[]{this, message, deliveryMode, priority, timeToLive});
            }
            this.checkState();
            ((TopicPublisher)this.producer).publish(message, deliveryMode, priority, timeToLive);
            logger.trace("sent {} result={}", (Object)this, (Object)message);
        }
        finally {
            this.session.unlock();
        }
    }

    public void publish(Message message) throws JMSException {
        this.session.lock();
        try {
            logger.trace("send {} result={}", (Object)this, (Object)message);
            this.checkState();
            ((TopicPublisher)this.producer).publish(message);
            logger.trace("sent {} result={}", (Object)this, (Object)message);
        }
        finally {
            this.session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Topic destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.lock();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("send {} destination={} message={} deliveryMode={} priority={} ttl={}", new Object[]{this, destination, message, deliveryMode, priority, timeToLive});
            }
            this.checkState();
            ((TopicPublisher)this.producer).publish(destination, message, deliveryMode, priority, timeToLive);
            logger.trace("sent {} result={}", (Object)this, (Object)message);
        }
        finally {
            this.session.unlock();
        }
    }

    public void publish(Topic destination, Message message) throws JMSException {
        this.session.lock();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("send {} destination={} message={}", new Object[]{this, destination, message});
            }
            this.checkState();
            ((TopicPublisher)this.producer).publish(destination, message);
            logger.trace("sent {} result={}", (Object)this, (Object)message);
        }
        finally {
            this.session.unlock();
        }
    }
}

