/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.unstable.api.annotation.classpath.index;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.wildfly.unstable.api.annotation.classpath.index.AnnotatedConstructor;
import org.wildfly.unstable.api.annotation.classpath.index.AnnotatedField;
import org.wildfly.unstable.api.annotation.classpath.index.AnnotatedMethod;

public class AnnotationIndex {
    private static final String START_MARKER = "==";
    private static final String END_MARKER = "=/";
    private static final String INTERFACES = "=INTERFACES";
    private static final String CLASSES = "=CLASSES";
    private static final String ANNOTATIONS = "=ANNOTATIONS";
    private static final String METHODS = "=METHODS";
    private static final String CONSTRUCTORS = "=CONSTRUCTORS";
    private static final String FIELDS = "=FIELDS";
    private static final String MULTI_VALUE_FIELD_SEPARATOR = "\u00b1";
    private final String annotationName;
    private final Set<String> annotatedInterfaces;
    private final Set<String> annotatedClasses;
    private final Set<String> annotatedAnnotations;
    private final Set<AnnotatedMethod> annotatedMethods;
    private final Set<AnnotatedConstructor> annotatedConstructors;
    private final Set<AnnotatedField> annotatedFields;

    protected AnnotationIndex(String annotationName, Set<String> annotatedInterfaces, Set<String> annotatedClasses, Set<String> annotatedAnnotations, Set<AnnotatedMethod> annotatedMethods, Set<AnnotatedConstructor> annotatedConstructors, Set<AnnotatedField> annotatedFields) {
        this.annotationName = annotationName;
        this.annotatedInterfaces = annotatedInterfaces;
        this.annotatedClasses = annotatedClasses;
        this.annotatedAnnotations = annotatedAnnotations;
        this.annotatedMethods = annotatedMethods;
        this.annotatedConstructors = annotatedConstructors;
        this.annotatedFields = annotatedFields;
    }

    AnnotationIndex(AnnotationIndex annotationIndex) {
        this(annotationIndex.annotationName, annotationIndex.annotatedInterfaces, annotationIndex.annotatedClasses, annotationIndex.annotatedAnnotations, annotationIndex.annotatedMethods, annotationIndex.annotatedConstructors, annotationIndex.annotatedFields);
    }

    void addIndexEntries(AnnotationIndex annotationIndex) {
        this.annotatedInterfaces.addAll(annotationIndex.getAnnotatedInterfaces());
        this.annotatedClasses.addAll(annotationIndex.getAnnotatedClasses());
        this.annotatedAnnotations.addAll(annotationIndex.getAnnotatedAnnotations());
        this.annotatedMethods.addAll(annotationIndex.getAnnotatedMethods());
        this.annotatedConstructors.addAll(annotationIndex.getAnnotatedConstructors());
        this.annotatedFields.addAll(annotationIndex.getAnnotatedFields());
    }

    String getAnnotationName() {
        return this.annotationName;
    }

    Set<String> getAnnotatedInterfaces() {
        return this.annotatedInterfaces;
    }

    Set<String> getAnnotatedClasses() {
        return this.annotatedClasses;
    }

    Set<String> getAnnotatedAnnotations() {
        return this.annotatedAnnotations;
    }

    Set<AnnotatedMethod> getAnnotatedMethods() {
        return this.annotatedMethods;
    }

    Set<AnnotatedConstructor> getAnnotatedConstructors() {
        return this.annotatedConstructors;
    }

    Set<AnnotatedField> getAnnotatedFields() {
        return this.annotatedFields;
    }

    void save(PrintWriter writer) {
        if (!(this.annotatedInterfaces.isEmpty() && this.annotatedClasses.isEmpty() && this.annotatedAnnotations.isEmpty() && this.annotatedMethods.isEmpty() && this.annotatedConstructors.isEmpty() && this.annotatedFields.isEmpty())) {
            writer.println(START_MARKER);
            writer.println(this.annotationName);
            if (!this.annotatedInterfaces.isEmpty()) {
                this.writeSimpleStringEntries(writer, INTERFACES, this.annotatedInterfaces);
            }
            if (!this.annotatedClasses.isEmpty()) {
                this.writeSimpleStringEntries(writer, CLASSES, this.annotatedClasses);
            }
            if (!this.annotatedAnnotations.isEmpty()) {
                this.writeSimpleStringEntries(writer, ANNOTATIONS, this.annotatedAnnotations);
            }
            if (!this.annotatedMethods.isEmpty()) {
                this.writeObjectEntries(writer, METHODS, this.annotatedMethods, m -> m.save(writer, MULTI_VALUE_FIELD_SEPARATOR));
            }
            if (!this.annotatedConstructors.isEmpty()) {
                this.writeObjectEntries(writer, CONSTRUCTORS, this.annotatedConstructors, c -> c.save(writer, MULTI_VALUE_FIELD_SEPARATOR));
            }
            if (!this.annotatedFields.isEmpty()) {
                this.writeObjectEntries(writer, FIELDS, this.annotatedFields, f -> f.save(writer, MULTI_VALUE_FIELD_SEPARATOR));
            }
            writer.println(END_MARKER);
        }
    }

    static Map<String, AnnotationIndex> loadAll(BufferedReader reader) throws IOException {
        HashMap<String, AnnotationIndex> map = new HashMap<String, AnnotationIndex>();
        String line = reader.readLine();
        while (line != null) {
            if (line.equals(START_MARKER)) {
                AnnotationIndex index = AnnotationIndex.load(reader);
                map.put(index.getAnnotationName(), index);
            }
            line = reader.readLine();
        }
        return map;
    }

    private static AnnotationIndex load(BufferedReader reader) throws IOException {
        HashSet<String> interfaces = new HashSet();
        HashSet<String> classes = new HashSet();
        HashSet<String> annotations = new HashSet();
        HashSet<AnnotatedMethod> methods = new HashSet();
        HashSet<AnnotatedConstructor> constructors = new HashSet();
        HashSet<AnnotatedField> fields = new HashSet();
        try {
            String annotation = reader.readLine();
            String line = reader.readLine();
            while (line != null) {
                switch (line) {
                    case "=INTERFACES": {
                        interfaces = AnnotationIndex.readSimpleStringLines(reader);
                        break;
                    }
                    case "=CLASSES": {
                        classes = AnnotationIndex.readSimpleStringLines(reader);
                        break;
                    }
                    case "=ANNOTATIONS": {
                        annotations = AnnotationIndex.readSimpleStringLines(reader);
                        break;
                    }
                    case "=METHODS": {
                        methods = AnnotationIndex.readLines(reader, s -> AnnotatedMethod.parseReadLine(s, MULTI_VALUE_FIELD_SEPARATOR));
                        break;
                    }
                    case "=CONSTRUCTORS": {
                        constructors = AnnotationIndex.readLines(reader, s -> AnnotatedConstructor.parseReadLine(s, MULTI_VALUE_FIELD_SEPARATOR));
                        break;
                    }
                    case "=FIELDS": {
                        fields = AnnotationIndex.readLines(reader, s -> AnnotatedField.parseReadLine(s, MULTI_VALUE_FIELD_SEPARATOR));
                        break;
                    }
                    case "=/": {
                        return new AnnotationIndex(annotation, interfaces, classes, annotations, methods, constructors, fields);
                    }
                }
                line = reader.readLine();
            }
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Premature end of file");
        }
        throw new RuntimeException("Premature end of file");
    }

    private static Set<String> readSimpleStringLines(BufferedReader reader) throws IOException {
        Set<String> results = AnnotationIndex.readLines(reader, s -> s);
        return results;
    }

    private static <R> Set<R> readLines(BufferedReader reader, Function<String, R> parser) throws IOException {
        HashSet<R> results = new HashSet<R>();
        String line = reader.readLine();
        while (!line.isEmpty()) {
            results.add(parser.apply(line));
            line = reader.readLine();
        }
        return results;
    }

    private void writeSimpleStringEntries(PrintWriter writer, String marker, Set<String> set) {
        this.writeObjectEntries(writer, marker, set, s -> writer.println((String)s));
    }

    private <T> void writeObjectEntries(PrintWriter writer, String marker, Set<T> set, Consumer<T> consumer) {
        writer.println(marker);
        for (T value : set) {
            consumer.accept(value);
        }
        writer.println();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnnotationIndex)) {
            return false;
        }
        AnnotationIndex that = (AnnotationIndex)o;
        return Objects.equals(this.annotationName, that.annotationName) && Objects.equals(this.annotatedInterfaces, that.annotatedInterfaces) && Objects.equals(this.annotatedClasses, that.annotatedClasses) && Objects.equals(this.annotatedAnnotations, that.annotatedAnnotations) && Objects.equals(this.annotatedMethods, that.annotatedMethods) && Objects.equals(this.annotatedConstructors, that.annotatedConstructors) && Objects.equals(this.annotatedFields, that.annotatedFields);
    }
}

