/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.unstable.api.annotation.classpath.runtime.bytecode;

import java.util.Objects;
import java.util.Set;
import org.wildfly.unstable.api.annotation.classpath.index.RuntimeIndex;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotationUsage;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotationUsageType;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotationWithSourceClassUsage;

public class AnnotatedMethodReference
extends AnnotationWithSourceClassUsage {
    private final String methodClass;
    private final String methodName;
    private final String descriptor;

    AnnotatedMethodReference(Set<String> annotations, String className, String methodClass, String methodName, String descriptor) {
        super(annotations, AnnotationUsageType.METHOD_REFERENCE, className);
        this.methodClass = methodClass;
        this.methodName = methodName;
        this.descriptor = descriptor;
    }

    public String getMethodClass() {
        return this.methodClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AnnotatedMethodReference that = (AnnotatedMethodReference)o;
        return Objects.equals(this.methodClass, that.methodClass) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.descriptor, that.descriptor);
    }

    @Override
    protected int calculateHash() {
        return Objects.hash(super.calculateHash(), this.methodClass, this.methodName, this.descriptor);
    }

    @Override
    protected AnnotationUsage convertToDotFormat() {
        return new AnnotatedMethodReference(this.annotations, RuntimeIndex.convertClassNameToDotFormat(this.sourceClass), RuntimeIndex.convertClassNameToDotFormat(this.methodClass), this.methodName, this.descriptor);
    }
}

