/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.IdentityHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.query.sqm.tree.SqmCopyContext;

public class SimpleSqmCopyContext
implements SqmCopyContext {
    private final IdentityHashMap<Object, Object> map = new IdentityHashMap();

    @Override
    public <T> @Nullable T getCopy(T original) {
        return (T)this.map.get(original);
    }

    @Override
    public <T> T registerCopy(T original, T copy) {
        Object old = this.map.put(original, copy);
        if (old != null) {
            throw new IllegalArgumentException("Already registered a copy: " + old);
        }
        return copy;
    }
}

