/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.time;

import java.io.IOException;
import java.time.LocalDate;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public enum LocalDateMarshaller implements FieldSetMarshaller.Simple<LocalDate>
{
    INSTANCE;

    private static final int POST_EPOCH_DAY = 0;
    private static final int PRE_EPOCH_DAY = 1;
    private static final int FIELDS = 2;
    private static final LocalDate EPOCH;

    @Override
    public LocalDate createInitialValue() {
        return EPOCH;
    }

    @Override
    public int getFields() {
        return 2;
    }

    @Override
    public LocalDate readFrom(ProtoStreamReader reader, int index, WireType type, LocalDate date) throws IOException {
        switch (index) {
            case 0: {
                return LocalDate.ofEpochDay(reader.readUInt64());
            }
            case 1: {
                return LocalDate.ofEpochDay(0L - reader.readUInt64());
            }
        }
        reader.skipField(type);
        return date;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, LocalDate date) throws IOException {
        long epochDay = date.toEpochDay();
        if (epochDay > 0L) {
            writer.writeUInt64(0, epochDay);
        } else if (epochDay < 0L) {
            writer.writeUInt64(1, 0L - epochDay);
        }
    }

    static {
        EPOCH = LocalDate.ofEpochDay(0L);
    }
}

