/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.message.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.SimpleType;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RefCountMessage;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.buffers.impl.ResetLimitWrappedActiveMQBuffer;
import org.apache.activemq.artemis.core.message.LargeBodyReader;
import org.apache.activemq.artemis.core.message.impl.CoreMessagePersister;
import org.apache.activemq.artemis.core.message.openmbean.MessageOpenTypeFactory;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreMessage
extends RefCountMessage
implements ICoreMessage {
    public static final int BUFFER_HEADER_SPACE = 13;
    protected volatile int memoryEstimate = -1;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int BODY_OFFSET = 4;
    protected ByteBuf buffer;
    private volatile boolean validBuffer = false;
    protected volatile ResetLimitWrappedActiveMQBuffer writableBuffer;
    protected int endOfBodyPosition = -1;
    protected int messageIDPosition = -1;
    protected long messageID;
    protected SimpleString address;
    protected byte type;
    protected boolean durable;
    protected boolean paged;
    private long expiration;
    protected long timestamp;
    protected byte priority;
    private UUID userID;
    private int propertiesLocation = -1;
    protected volatile TypedProperties properties;
    private final CoreMessageObjectPools coreMessageObjectPools;
    private volatile Object owner;
    private static MessageOpenTypeFactory TEXT_FACTORY = new TextMessageOpenTypeFactory();
    private static MessageOpenTypeFactory BYTES_FACTORY = new BytesMessageOpenTypeFactory();

    public CoreMessage(CoreMessageObjectPools coreMessageObjectPools) {
        this.coreMessageObjectPools = coreMessageObjectPools;
    }

    public CoreMessage() {
        this.coreMessageObjectPools = null;
    }

    @Override
    public void setPaged() {
        this.paged = true;
    }

    @Override
    public boolean isPaged() {
        return this.paged;
    }

    @Override
    public String getProtocolName() {
        return "CORE";
    }

    @Override
    public Object getAnnotation(SimpleString key) {
        return this.getObjectProperty(key);
    }

    @Override
    public Object removeAnnotation(SimpleString key) {
        return this.removeProperty(key);
    }

    @Override
    public void clearInternalProperties() {
        TypedProperties properties = this.properties;
        if (properties != null && properties.clearInternalProperties()) {
            this.messageChanged();
        }
    }

    @Override
    public Persister<Message> getPersister() {
        return CoreMessagePersister.getInstance();
    }

    public CoreMessage initBuffer(int initialMessageBufferSize) {
        this.buffer = Unpooled.buffer(initialMessageBufferSize);
        this.buffer.writeByte(0);
        this.buffer.setIndex(4, 4);
        return this;
    }

    @Override
    public SimpleString getReplyTo() {
        return this.getSimpleStringProperty(MessageUtil.REPLYTO_HEADER_NAME);
    }

    @Override
    public RoutingType getRoutingType() {
        Byte maybeByte = this.getProperties().getByteProperty(Message.HDR_ROUTING_TYPE, () -> null);
        if (maybeByte == null) {
            return null;
        }
        return RoutingType.getType(maybeByte);
    }

    @Override
    public Message setRoutingType(RoutingType routingType) {
        if (routingType == null) {
            this.removeProperty(Message.HDR_ROUTING_TYPE);
        } else {
            this.putByteProperty(Message.HDR_ROUTING_TYPE, routingType.getType());
        }
        return this;
    }

    @Override
    public CoreMessage setReplyTo(SimpleString address) {
        if (address == null) {
            this.getProperties().removeProperty(MessageUtil.REPLYTO_HEADER_NAME);
        } else {
            this.putStringProperty(MessageUtil.REPLYTO_HEADER_NAME, address);
        }
        return this;
    }

    @Override
    public void receiveBuffer(ByteBuf buffer) {
        this.buffer = buffer;
        this.buffer.retain();
        this.decode(false);
    }

    @Override
    public void receiveBuffer_1X(ByteBuf buffer) {
        this.buffer = buffer;
        this.buffer.retain();
        this.decode(true);
        this.validBuffer = false;
    }

    @Override
    public ActiveMQBuffer getReadOnlyBodyBuffer() {
        this.checkEncode();
        return new ChannelBufferWrapper(this.buffer.slice(4, this.endOfBodyPosition - 13).setIndex(0, this.endOfBodyPosition - 13).asReadOnly());
    }

    @Override
    public int getBodyBufferSize() {
        this.checkEncode();
        return this.endOfBodyPosition - 13;
    }

    @Override
    public ActiveMQBuffer getDataBuffer() {
        ActiveMQBuffer buffer;
        try {
            buffer = this.isLargeMessage() ? this.getLargeMessageBuffer() : this.getReadOnlyBodyBuffer();
            if (Boolean.TRUE.equals(this.getBooleanProperty(Message.HDR_LARGE_COMPRESSED))) {
                buffer = this.inflate(buffer);
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), e);
            return this.getReadOnlyBodyBuffer();
        }
        return buffer;
    }

    private ActiveMQBuffer getLargeMessageBuffer() throws ActiveMQException {
        LargeBodyReader encoder = this.getLargeBodyReader();
        encoder.open();
        int bodySize = (int)encoder.getSize();
        ChannelBufferWrapper buffer = new ChannelBufferWrapper(UnpooledByteBufAllocator.DEFAULT.heapBuffer(bodySize));
        buffer.byteBuf().ensureWritable(bodySize);
        ByteBuffer nioBuffer = buffer.byteBuf().internalNioBuffer(0, bodySize);
        encoder.readInto(nioBuffer);
        buffer.writerIndex(bodySize);
        encoder.close();
        return buffer;
    }

    private ActiveMQBuffer inflate(ActiveMQBuffer buffer) throws DataFormatException {
        int bytesToRead = buffer.readableBytes();
        Inflater inflater = new Inflater();
        byte[] input = new byte[bytesToRead];
        buffer.readBytes(input);
        inflater.setInput(input);
        long sizeBody = this.getLongProperty(Message.HDR_LARGE_BODY_SIZE);
        byte[] data = new byte[(int)sizeBody];
        inflater.inflate(data);
        inflater.end();
        ActiveMQBuffer qbuff = ActiveMQBuffers.wrappedBuffer(data);
        qbuff.resetReaderIndex();
        qbuff.resetWriterIndex();
        qbuff.writeBytes(data);
        buffer = qbuff;
        return buffer;
    }

    @Override
    public SimpleString getGroupID() {
        return this.getSimpleStringProperty(Message.HDR_GROUP_ID);
    }

    @Override
    public CoreMessage setGroupID(SimpleString groupId) {
        return this.putStringProperty(Message.HDR_GROUP_ID, groupId);
    }

    @Override
    public CoreMessage setGroupID(String groupId) {
        return this.setGroupID(SimpleString.of(groupId, this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getGroupIdStringSimpleStringPool()));
    }

    @Override
    public int getGroupSequence() {
        return this.containsProperty(Message.HDR_GROUP_SEQUENCE) ? this.getIntProperty(Message.HDR_GROUP_SEQUENCE) : 0;
    }

    @Override
    public CoreMessage setGroupSequence(int sequence) {
        return this.putIntProperty(Message.HDR_GROUP_SEQUENCE, sequence);
    }

    @Override
    public Object getCorrelationID() {
        return this.getObjectProperty(MessageUtil.CORRELATIONID_HEADER_NAME);
    }

    @Override
    public Message setCorrelationID(Object correlationID) {
        this.putObjectProperty(MessageUtil.CORRELATIONID_HEADER_NAME, correlationID);
        return this;
    }

    @Override
    public synchronized void sendBuffer(ByteBuf sendBuffer, int deliveryCount) {
        this.checkEncode();
        sendBuffer.writeBytes(this.buffer, 0, this.buffer.writerIndex());
    }

    @Override
    public synchronized void sendBuffer_1X(ByteBuf sendBuffer) {
        this.checkEncode();
        ByteBuf tmpBuffer = this.buffer.duplicate();
        sendBuffer.writeInt(this.endOfBodyPosition + 4);
        tmpBuffer.readerIndex(4);
        tmpBuffer.readBytes(sendBuffer, this.endOfBodyPosition - 13);
        sendBuffer.writeInt(tmpBuffer.writerIndex() + 4 + 13);
        tmpBuffer.readBytes(sendBuffer, tmpBuffer.readableBytes());
        sendBuffer.readerIndex(0);
    }

    protected synchronized void checkEncode() {
        if (!this.validBuffer) {
            this.encode();
        }
        this.internalWritableBuffer();
    }

    @Override
    public Long getScheduledDeliveryTime() {
        Object property = this.getProperties().getProperty(Message.HDR_SCHEDULED_DELIVERY_TIME);
        if (property != null && property instanceof Number) {
            return ((Number)property).longValue();
        }
        return 0L;
    }

    @Override
    public CoreMessage setScheduledDeliveryTime(Long time) {
        if (time == null || time == 0L) {
            this.getProperties().removeProperty(Message.HDR_SCHEDULED_DELIVERY_TIME);
        } else {
            this.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, (long)time);
        }
        return this;
    }

    @Override
    public InputStream getBodyInputStream() {
        return null;
    }

    @Override
    public ActiveMQBuffer getBodyBuffer() {
        this.getProperties();
        this.internalWritableBuffer();
        return this.writableBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalWritableBuffer() {
        if (this.writableBuffer == null) {
            CoreMessage coreMessage = this;
            synchronized (coreMessage) {
                if (this.writableBuffer == null) {
                    ResetLimitWrappedActiveMQBuffer writableBuffer = new ResetLimitWrappedActiveMQBuffer(4, this.buffer.duplicate(), (Message)this);
                    if (this.endOfBodyPosition > 0) {
                        writableBuffer.byteBuf().setIndex(4, this.endOfBodyPosition - 13 + 4);
                        writableBuffer.resetReaderIndex();
                    }
                    this.writableBuffer = writableBuffer;
                }
            }
        }
    }

    @Override
    public int getEndOfBodyPosition() {
        if (this.endOfBodyPosition < 0) {
            this.endOfBodyPosition = this.getBodyBuffer().writerIndex();
        }
        return this.endOfBodyPosition;
    }

    @Override
    public synchronized void messageChanged() {
        if (this.validBuffer) {
            this.validBuffer = false;
        }
    }

    protected CoreMessage(CoreMessage other) {
        this(other, other.properties);
    }

    public CoreMessage(long id, int bufferSize) {
        this(id, bufferSize, null);
    }

    public CoreMessage(long id, int bufferSize, CoreMessageObjectPools coreMessageObjectPools) {
        this.initBuffer(bufferSize);
        this.setMessageID(id);
        this.coreMessageObjectPools = coreMessageObjectPools;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoreMessage(CoreMessage other, TypedProperties copyProperties) {
        CoreMessage coreMessage = other;
        synchronized (coreMessage) {
            this.endOfBodyPosition = other.endOfBodyPosition;
            this.internalSetMessageID(other.messageID);
            this.address = other.address;
            this.type = other.type;
            this.durable = other.durable;
            this.expiration = other.expiration;
            this.timestamp = other.timestamp;
            this.priority = other.priority;
            this.userID = other.userID;
            this.coreMessageObjectPools = other.coreMessageObjectPools;
            if (copyProperties != null) {
                this.properties = new TypedProperties(copyProperties);
            }
            if (other.buffer != null) {
                this.buffer = other.buffer.copy();
            }
        }
    }

    protected void internalSetMessageID(long messageID) {
        this.messageID = messageID;
    }

    @Override
    public void moveHeadersAndProperties(Message msg) {
        this.internalSetMessageID(msg.getMessageID());
        this.address = msg.getAddressSimpleString();
        this.userID = (UUID)msg.getUserID();
        this.type = msg.toCore().getType();
        this.durable = msg.isDurable();
        this.expiration = msg.getExpiration();
        this.timestamp = msg.getTimestamp();
        this.priority = msg.getPriority();
        if (msg instanceof CoreMessage) {
            this.properties = new TypedProperties(((CoreMessage)msg).getProperties());
        }
    }

    @Override
    public Message copy() {
        this.getProperties();
        this.checkEncode();
        return new CoreMessage(this);
    }

    @Override
    public Message copy(long newID) {
        return this.copy().setMessageID(newID);
    }

    @Override
    public long getExpiration() {
        return this.expiration;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public CoreMessage setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Override
    public long getMessageID() {
        return this.messageID;
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    @Override
    public UUID getUserID() {
        return this.userID;
    }

    @Override
    public CoreMessage setUserID(Object uuid) {
        this.userID = (UUID)uuid;
        return this;
    }

    @Override
    public String getValidatedUserID() {
        return this.getStringProperty(Message.HDR_VALIDATED_USER);
    }

    @Override
    public CoreMessage setValidatedUserID(String validatedUserID) {
        this.putStringProperty(Message.HDR_VALIDATED_USER, this.value(validatedUserID));
        return this;
    }

    @Override
    public CoreMessage setMessageID(long messageID) {
        this.internalSetMessageID(messageID);
        if (this.messageIDPosition >= 0 && this.validBuffer) {
            this.buffer.setLong(this.messageIDPosition, messageID);
        }
        return this;
    }

    @Override
    public CoreMessage setAddress(SimpleString address) {
        if (address == null && this.address == null) {
            return this;
        }
        if (this.validBuffer && (address == null || !address.equals(this.address))) {
            this.messageChanged();
        }
        this.address = address;
        return this;
    }

    @Override
    public SimpleString getAddressSimpleString() {
        return this.address;
    }

    @Override
    public CoreMessage setExpiration(long expiration) {
        this.expiration = expiration;
        this.messageChanged();
        return this;
    }

    @Override
    public CoreMessage setPriority(byte priority) {
        this.priority = priority;
        this.messageChanged();
        return this;
    }

    public CoreMessage setUserID(UUID userID) {
        this.userID = userID;
        this.messageChanged();
        return this;
    }

    public final TypedProperties getProperties() {
        TypedProperties properties = this.properties;
        if (properties == null) {
            properties = this.getOrInitializeTypedProperties();
        }
        return properties;
    }

    private synchronized TypedProperties getOrInitializeTypedProperties() {
        try {
            TypedProperties properties = this.properties;
            if (properties == null) {
                properties = new TypedProperties(INTERNAL_PROPERTY_NAMES_PREDICATE);
                if (this.buffer != null && this.propertiesLocation >= 0) {
                    ByteBuf byteBuf = this.buffer.duplicate().readerIndex(this.propertiesLocation);
                    properties.decode(byteBuf, this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getPropertiesDecoderPools());
                }
                this.properties = properties;
            }
            return properties;
        }
        catch (Throwable e) {
            throw this.onCheckPropertiesError(e);
        }
    }

    private RuntimeException onCheckPropertiesError(Throwable e) {
        logger.warn("Could not decode properties for CoreMessage[messageID={},durable={},userID={},priority={}, timestamp={},expiration={},address={}, propertiesLocation={}", this.messageID, this.durable, this.userID, this.priority, this.timestamp, this.expiration, this.address, this.propertiesLocation, e);
        ByteBuf buffer = this.buffer;
        if (buffer != null) {
            ByteBuf duplicatebuffer = buffer.duplicate();
            duplicatebuffer.readerIndex(0);
            logger.warn("Failed message has messageID={} and the following buffer:\n{}", (Object)this.messageID, (Object)ByteBufUtil.prettyHexDump(duplicatebuffer));
        } else {
            logger.warn("Failed message has messageID={} and the buffer was null", (Object)this.messageID);
        }
        return new RuntimeException(e.getMessage(), e);
    }

    @Override
    public int getMemoryEstimate() {
        if (this.memoryEstimate == -1) {
            if (this.buffer != null && !this.isLargeMessage() && !this.validBuffer) {
                this.checkEncode();
            }
            TypedProperties properties = this.properties;
            this.memoryEstimate = 352 + (this.buffer != null ? this.buffer.capacity() : 0) + (properties != null ? properties.getMemoryOffset() : 0);
        }
        return this.memoryEstimate;
    }

    @Override
    public boolean isServerMessage() {
        return false;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public CoreMessage setType(byte type) {
        this.type = type;
        return this;
    }

    private void decode(boolean beforeAddress) {
        this.decode(beforeAddress, this.coreMessageObjectPools);
    }

    private void decode(boolean beforeAddress, CoreMessageObjectPools pools) {
        this.endOfBodyPosition = this.buffer.readInt();
        this.buffer.skipBytes(this.endOfBodyPosition - 13);
        this.decodeHeadersAndProperties(this.buffer, true, pools);
        this.buffer.readerIndex(0);
        this.validBuffer = true;
        if (beforeAddress) {
            this.endOfBodyPosition -= 4;
        }
        this.internalWritableBuffer();
    }

    public void decodeHeadersAndProperties(ByteBuf buffer) {
        this.decodeHeadersAndProperties(buffer, false, this.coreMessageObjectPools);
    }

    private void decodeHeadersAndProperties(ByteBuf buffer, boolean lazyProperties, CoreMessageObjectPools pools) {
        this.messageIDPosition = buffer.readerIndex();
        this.internalSetMessageID(buffer.readLong());
        this.address = SimpleString.readNullableSimpleString(buffer, pools == null ? null : pools.getAddressDecoderPool());
        if (buffer.readByte() == 1) {
            byte[] bytes = new byte[16];
            buffer.readBytes(bytes);
            this.userID = new UUID(1, bytes);
        } else {
            this.userID = null;
        }
        this.type = buffer.readByte();
        this.durable = buffer.readBoolean();
        this.expiration = buffer.readLong();
        this.timestamp = buffer.readLong();
        this.priority = buffer.readByte();
        if (lazyProperties) {
            this.properties = null;
            this.propertiesLocation = buffer.readerIndex();
        } else {
            this.properties = new TypedProperties(INTERNAL_PROPERTY_NAMES_PREDICATE);
            this.properties.decode(buffer, pools == null ? null : pools.getPropertiesDecoderPools());
        }
    }

    public synchronized CoreMessage encode() {
        this.getProperties();
        if (this.writableBuffer != null) {
            this.endOfBodyPosition = this.writableBuffer.writerIndex() + 13 - 4;
        } else if (this.endOfBodyPosition <= 0) {
            this.endOfBodyPosition = 17;
        }
        this.buffer.setInt(0, this.endOfBodyPosition);
        this.buffer.setIndex(0, this.endOfBodyPosition - 13 + 4);
        this.encodeHeadersAndProperties(this.buffer);
        this.validBuffer = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeHeadersAndProperties(ByteBuf buffer) {
        int initialWriterIndex;
        TypedProperties properties = this.getProperties();
        this.messageIDPosition = initialWriterIndex = buffer.writerIndex();
        UUID userID = this.userID;
        int userIDEncodedSize = userID == null ? 1 : 1 + userID.asBytes().length;
        SimpleString address = this.address;
        int addressEncodedBytes = SimpleString.sizeofNullableString(address);
        int headersSize = 8 + addressEncodedBytes + userIDEncodedSize + 1 + 1 + 8 + 8 + 1;
        TypedProperties typedProperties = properties;
        synchronized (typedProperties) {
            int propertiesEncodeSize = properties.getEncodeSize();
            int totalEncodedSize = headersSize + propertiesEncodeSize;
            ByteUtil.ensureExactWritable(buffer, totalEncodedSize);
            buffer.writeLong(this.messageID);
            SimpleString.writeNullableSimpleString(buffer, address);
            if (userID == null) {
                buffer.writeByte(0);
            } else {
                buffer.writeByte(1);
                buffer.writeBytes(userID.asBytes());
            }
            buffer.writeByte(this.type);
            buffer.writeBoolean(this.durable);
            buffer.writeLong(this.expiration);
            buffer.writeLong(this.timestamp);
            buffer.writeByte(this.priority);
            assert (buffer.writerIndex() == initialWriterIndex + headersSize) : "Bad Headers encode size estimation";
            int realPropertiesEncodeSize = properties.encode(buffer);
            assert (realPropertiesEncodeSize == propertiesEncodeSize) : "TypedProperties has a wrong encode size estimation or is being modified concurrently";
        }
    }

    @Override
    public int getHeadersAndPropertiesEncodeSize() {
        return 9 + (this.userID == null ? 0 : 16) + SimpleString.sizeofNullableString(this.address) + 1 + 1 + 8 + 8 + 1 + this.getProperties().getEncodeSize();
    }

    @Override
    public Object getDuplicateProperty() {
        return this.getObjectProperty(Message.HDR_DUPLICATE_DETECTION_ID);
    }

    @Override
    public SimpleString getLastValueProperty() {
        return this.getSimpleStringProperty(Message.HDR_LAST_VALUE_NAME);
    }

    @Override
    public Message setLastValueProperty(SimpleString lastValueName) {
        return this.putStringProperty(Message.HDR_LAST_VALUE_NAME, lastValueName);
    }

    @Override
    public int getEncodeSize() {
        if (this.buffer == null) {
            return -1;
        }
        this.checkEncode();
        return this.buffer.writerIndex();
    }

    @Override
    public boolean isLargeMessage() {
        return false;
    }

    @Override
    public String getAddress() {
        if (this.address == null) {
            return null;
        }
        return this.address.toString();
    }

    @Override
    public CoreMessage setAddress(String address) {
        this.messageChanged();
        this.address = SimpleString.of(address, this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getAddressStringSimpleStringPool());
        return this;
    }

    @Override
    public CoreMessage setBuffer(ByteBuf buffer) {
        this.buffer = buffer;
        return this;
    }

    @Override
    public ByteBuf getBuffer() {
        return this.buffer;
    }

    @Override
    public boolean isDurable() {
        return this.durable;
    }

    @Override
    public CoreMessage setDurable(boolean durable) {
        this.messageChanged();
        this.durable = durable;
        return this;
    }

    @Override
    public CoreMessage putBooleanProperty(String key, boolean value) {
        return this.putBooleanProperty(this.key(key), value);
    }

    @Override
    public CoreMessage putBooleanProperty(SimpleString key, boolean value) {
        this.messageChanged();
        this.getProperties().putBooleanProperty(key, value);
        return this;
    }

    @Override
    public Boolean getBooleanProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getProperties().getBooleanProperty(key);
    }

    @Override
    public Boolean getBooleanProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getBooleanProperty(this.key(key));
    }

    @Override
    public CoreMessage putByteProperty(SimpleString key, byte value) {
        this.messageChanged();
        this.getProperties().putByteProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putByteProperty(String key, byte value) {
        return this.putByteProperty(this.key(key), value);
    }

    @Override
    public Byte getByteProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getProperties().getByteProperty(key);
    }

    @Override
    public Byte getByteProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getByteProperty(this.key(key));
    }

    @Override
    public CoreMessage putBytesProperty(SimpleString key, byte[] value) {
        this.messageChanged();
        this.getProperties().putBytesProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putBytesProperty(String key, byte[] value) {
        return this.putBytesProperty(this.key(key), value);
    }

    @Override
    public byte[] getBytesProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getProperties().getBytesProperty(key);
    }

    @Override
    public byte[] getBytesProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getBytesProperty(this.key(key));
    }

    @Override
    public CoreMessage putCharProperty(SimpleString key, char value) {
        this.messageChanged();
        this.getProperties().putCharProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putCharProperty(String key, char value) {
        return this.putCharProperty(this.key(key), value);
    }

    @Override
    public CoreMessage putShortProperty(SimpleString key, short value) {
        this.messageChanged();
        this.getProperties().putShortProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putShortProperty(String key, short value) {
        return this.putShortProperty(this.key(key), value);
    }

    @Override
    public CoreMessage putIntProperty(SimpleString key, int value) {
        this.messageChanged();
        this.getProperties().putIntProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putIntProperty(String key, int value) {
        return this.putIntProperty(this.key(key), value);
    }

    @Override
    public Integer getIntProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getProperties().getIntProperty(key);
    }

    @Override
    public Integer getIntProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getIntProperty(this.key(key));
    }

    @Override
    public CoreMessage putLongProperty(SimpleString key, long value) {
        this.messageChanged();
        this.getProperties().putLongProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putLongProperty(String key, long value) {
        return this.putLongProperty(this.key(key), value);
    }

    @Override
    public Long getLongProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getProperties().getLongProperty(key);
    }

    @Override
    public Long getLongProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getLongProperty(this.key(key));
    }

    @Override
    public CoreMessage putFloatProperty(SimpleString key, float value) {
        this.messageChanged();
        this.getProperties().putFloatProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putFloatProperty(String key, float value) {
        return this.putFloatProperty(this.key(key), value);
    }

    @Override
    public CoreMessage putDoubleProperty(SimpleString key, double value) {
        this.messageChanged();
        this.getProperties().putDoubleProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putDoubleProperty(String key, double value) {
        return this.putDoubleProperty(this.key(key), value);
    }

    @Override
    public Double getDoubleProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getProperties().getDoubleProperty(key);
    }

    @Override
    public Double getDoubleProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getDoubleProperty(this.key(key));
    }

    @Override
    public CoreMessage putStringProperty(SimpleString key, SimpleString value) {
        this.messageChanged();
        this.getProperties().putSimpleStringProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putStringProperty(SimpleString key, String value) {
        return this.putStringProperty(key, this.value(value));
    }

    @Override
    public CoreMessage putStringProperty(String key, String value) {
        return this.putStringProperty(this.key(key), this.value(value));
    }

    @Override
    public CoreMessage putObjectProperty(SimpleString key, Object value) throws ActiveMQPropertyConversionException {
        this.messageChanged();
        TypedProperties.setObjectProperty(key, value, this.getProperties());
        return this;
    }

    @Override
    public Object getObjectProperty(String key) {
        return this.getObjectProperty(this.key(key));
    }

    @Override
    public Object getObjectProperty(SimpleString key) {
        return this.getProperties().getProperty(key);
    }

    @Override
    public CoreMessage putObjectProperty(String key, Object value) throws ActiveMQPropertyConversionException {
        return this.putObjectProperty(this.key(key), value);
    }

    @Override
    public Short getShortProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getProperties().getShortProperty(key);
    }

    @Override
    public Short getShortProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getShortProperty(this.key(key));
    }

    @Override
    public Float getFloatProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getProperties().getFloatProperty(key);
    }

    @Override
    public Float getFloatProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getFloatProperty(this.key(key));
    }

    @Override
    public String getStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        SimpleString str = this.getSimpleStringProperty(key);
        if (str == null) {
            return null;
        }
        return str.toString();
    }

    @Override
    public String getStringProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getStringProperty(this.key(key));
    }

    @Override
    public SimpleString getSimpleStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getProperties().getSimpleStringProperty(key);
    }

    @Override
    public SimpleString getSimpleStringProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getSimpleStringProperty(this.key(key));
    }

    @Override
    public Object removeProperty(SimpleString key) {
        Object oldValue = this.getProperties().removeProperty(key);
        if (oldValue != null) {
            this.messageChanged();
        }
        return oldValue;
    }

    @Override
    public Object removeProperty(String key) {
        return this.removeProperty(this.key(key));
    }

    @Override
    public boolean hasScheduledDeliveryTime() {
        return this.searchProperty(Message.HDR_SCHEDULED_DELIVERY_TIME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean searchProperty(SimpleString key) {
        Objects.requireNonNull(key, "key cannot be null");
        TypedProperties properties = this.properties;
        if (properties != null) {
            return properties.containsProperty(key);
        }
        CoreMessage coreMessage = this;
        synchronized (coreMessage) {
            ByteBuf buffer = this.buffer;
            if (buffer == null) {
                throw new NullPointerException("buffer cannot be null");
            }
            int propertiesLocation = this.propertiesLocation;
            if (propertiesLocation < 0) {
                throw new IllegalStateException("propertiesLocation = " + propertiesLocation);
            }
            return TypedProperties.searchProperty(key, buffer, propertiesLocation);
        }
    }

    @Override
    public boolean containsProperty(SimpleString key) {
        return this.getProperties().containsProperty(key);
    }

    @Override
    public boolean containsProperty(String key) {
        return this.containsProperty(this.key(key));
    }

    @Override
    public Set<SimpleString> getPropertyNames() {
        return this.getProperties().getPropertyNames();
    }

    @Override
    public LargeBodyReader getLargeBodyReader() throws ActiveMQException {
        return new CoreLargeBodyReaderImpl();
    }

    @Override
    public int getPersistSize() {
        this.checkEncode();
        return this.buffer.writerIndex() + 4;
    }

    @Override
    public void persist(ActiveMQBuffer targetRecord) {
        this.checkEncode();
        targetRecord.writeInt(this.buffer.writerIndex());
        targetRecord.writeBytes(this.buffer, 0, this.buffer.writerIndex());
    }

    @Override
    public void reloadPersistence(ActiveMQBuffer record, CoreMessageObjectPools pools) {
        int size = record.readInt();
        this.initBuffer(size);
        this.buffer.setIndex(0, 0).writeBytes(record.byteBuf(), size);
        this.decode(false, pools);
    }

    @Override
    public CoreMessage toCore() {
        return this;
    }

    @Override
    public CoreMessage toCore(CoreMessageObjectPools coreMessageObjectPools) {
        return this;
    }

    public String toString() {
        try {
            TypedProperties properties = this.getProperties();
            return "CoreMessage[messageID=" + this.messageID + ", durable=" + this.isDurable() + ", userID=" + this.getUserID() + ", priority=" + this.getPriority() + ", timestamp=" + CoreMessage.toDate(this.getTimestamp()) + ", expiration=" + CoreMessage.toDate(this.getExpiration()) + ", durable=" + this.durable + ", address=" + this.getAddress() + ", size=" + this.getPersistentSize() + ", properties=" + properties + "]@" + System.identityHashCode(this);
        }
        catch (Throwable e) {
            logger.warn("Error creating String for message: ", e);
            return "ServerMessage[messageID=" + this.messageID + "]";
        }
    }

    private static String toDate(long timestamp) {
        if (timestamp == 0L) {
            return "0";
        }
        return new Date(timestamp).toString();
    }

    private SimpleString key(String key) {
        return SimpleString.of(key, this.getPropertyKeysPool());
    }

    private SimpleString value(String value) {
        return SimpleString.of(value, this.getPropertyValuesPool());
    }

    private SimpleString.StringSimpleStringPool getPropertyKeysPool() {
        return this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getPropertiesStringSimpleStringPools().getPropertyKeysPool();
    }

    private SimpleString.StringSimpleStringPool getPropertyValuesPool() {
        return this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getPropertiesStringSimpleStringPools().getPropertyValuesPool();
    }

    @Override
    public long getPersistentSize() throws ActiveMQException {
        return this.getEncodeSize();
    }

    @Override
    public Object getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Object object) {
        this.owner = object;
    }

    @Override
    public String getStringBody() {
        String body = null;
        if (this.type == 3) {
            try {
                SimpleString simpleBody = this.getDataBuffer().readNullableSimpleString();
                if (simpleBody != null) {
                    body = simpleBody.toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return body;
    }

    @Override
    public CompositeData toCompositeData(int fieldsLimit, int deliveryCount) throws OpenDataException {
        Map<String, Object> fields;
        CompositeType ct;
        byte type = this.getType();
        switch (type) {
            case 3: {
                ct = TEXT_FACTORY.getCompositeType();
                fields = TEXT_FACTORY.getFields(this, fieldsLimit, deliveryCount);
                break;
            }
            default: {
                ct = BYTES_FACTORY.getCompositeType();
                fields = BYTES_FACTORY.getFields(this, fieldsLimit, deliveryCount);
            }
        }
        return new CompositeDataSupport(ct, fields);
    }

    static class TextMessageOpenTypeFactory
    extends MessageOpenTypeFactory<CoreMessage> {
        TextMessageOpenTypeFactory() {
        }

        @Override
        protected void init() throws OpenDataException {
            super.init();
            this.addItem("text", "text", SimpleType.STRING);
        }

        @Override
        public Map<String, Object> getFields(CoreMessage m, int valueSizeLimit, int delivery) throws OpenDataException {
            Map<String, Object> rc = super.getFields(m, valueSizeLimit, delivery);
            rc.put("type", m.getType());
            if (!m.isLargeMessage()) {
                if (m.containsProperty(Message.HDR_LARGE_COMPRESSED)) {
                    rc.put("text", "[compressed]");
                } else {
                    SimpleString text = m.getReadOnlyBodyBuffer().readNullableSimpleString();
                    rc.put("text", JsonUtil.truncate(text != null ? text.toString() : text, valueSizeLimit));
                }
            } else {
                rc.put("text", "[large message]");
            }
            return rc;
        }
    }

    static class BytesMessageOpenTypeFactory
    extends MessageOpenTypeFactory<CoreMessage> {
        protected ArrayType body;

        BytesMessageOpenTypeFactory() {
        }

        @Override
        protected void init() throws OpenDataException {
            super.init();
            this.body = new ArrayType(SimpleType.BYTE, true);
            this.addItem("BodyPreview", "The message body", this.body);
        }

        @Override
        public Map<String, Object> getFields(CoreMessage m, int valueSizeLimit, int delivery) throws OpenDataException {
            Map<String, Object> rc = super.getFields(m, valueSizeLimit, delivery);
            rc.put("type", m.getType());
            if (!m.isLargeMessage()) {
                ActiveMQBuffer bodyCopy = m.getReadOnlyBodyBuffer();
                int arraySize = valueSizeLimit == -1 || bodyCopy.readableBytes() <= valueSizeLimit ? bodyCopy.readableBytes() : valueSizeLimit;
                byte[] bytes = new byte[arraySize];
                bodyCopy.readBytes(bytes);
                rc.put("BodyPreview", JsonUtil.truncate(bytes, valueSizeLimit));
            } else {
                rc.put("BodyPreview", new byte[0]);
            }
            return rc;
        }
    }

    private final class CoreLargeBodyReaderImpl
    implements LargeBodyReader {
        private int lastPos = 0;

        private CoreLargeBodyReaderImpl() {
        }

        @Override
        public void open() {
        }

        @Override
        public void position(long position) throws ActiveMQException {
            this.lastPos = (int)position;
        }

        @Override
        public long position() {
            return this.lastPos;
        }

        @Override
        public void close() {
        }

        @Override
        public long getSize() {
            return CoreMessage.this.buffer.writerIndex();
        }

        @Override
        public int readInto(ByteBuffer bufferRead) {
            int remaining = bufferRead.remaining();
            CoreMessage.this.buffer.getBytes(this.lastPos, bufferRead);
            this.lastPos += remaining;
            return remaining;
        }
    }
}

