/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core.metrics;

import io.github.resilience4j.core.metrics.Measurement;
import io.github.resilience4j.core.metrics.Metrics;
import io.github.resilience4j.core.metrics.Snapshot;
import io.github.resilience4j.core.metrics.SnapshotImpl;
import io.github.resilience4j.core.metrics.TotalAggregation;
import java.util.concurrent.TimeUnit;

public class FixedSizeSlidingWindowMetrics
implements Metrics {
    private final int windowSize;
    private final TotalAggregation totalAggregation;
    private final Measurement[] measurements;
    int headIndex;

    public FixedSizeSlidingWindowMetrics(int windowSize) {
        this.windowSize = windowSize;
        this.measurements = new Measurement[this.windowSize];
        this.headIndex = 0;
        for (int i = 0; i < this.windowSize; ++i) {
            this.measurements[i] = new Measurement();
        }
        this.totalAggregation = new TotalAggregation();
    }

    @Override
    public synchronized Snapshot record(long duration, TimeUnit durationUnit, Metrics.Outcome outcome) {
        this.totalAggregation.record(duration, durationUnit, outcome);
        this.moveWindowByOne().record(duration, durationUnit, outcome);
        return new SnapshotImpl(this.totalAggregation);
    }

    @Override
    public synchronized Snapshot getSnapshot() {
        return new SnapshotImpl(this.totalAggregation);
    }

    private Measurement moveWindowByOne() {
        this.moveHeadIndexByOne();
        Measurement latestMeasurement = this.getLatestMeasurement();
        this.totalAggregation.removeBucket(latestMeasurement);
        latestMeasurement.reset();
        return latestMeasurement;
    }

    private Measurement getLatestMeasurement() {
        return this.measurements[this.headIndex];
    }

    void moveHeadIndexByOne() {
        this.headIndex = (this.headIndex + 1) % this.windowSize;
    }
}

