/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.server.dispatcher;

import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jgroups.Address;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.group.GroupCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.dispatcher.ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.infinispan.dispatcher.EmbeddedCacheManagerCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.dispatcher.LocalEmbeddedCacheManagerCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.jgroups.ChannelGroupMember;
import org.wildfly.clustering.server.jgroups.dispatcher.ChannelCommandDispatcherFactory;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.common.function.Functions;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CacheContainerCommandDispatcherFactoryServiceInstallerFactory implements BiFunction<CapabilityServiceSupport, Map.Entry<String, String>, ServiceInstaller>
{
    INSTANCE{

        @Override
        public ServiceInstaller apply(CapabilityServiceSupport support, Map.Entry<String, String> entry) {
            CacheContainerCommandDispatcherFactoryServiceInstallerFactory installerFactory = "local".equals(entry.getValue()) ? LOCAL : CHANNEL;
            return (ServiceInstaller)installerFactory.apply(support, entry);
        }
    }
    ,
    CHANNEL{

        @Override
        public ServiceInstaller apply(CapabilityServiceSupport support, Map.Entry<String, String> entry) {
            String containerName = entry.getKey();
            String channelName = entry.getValue();
            final ServiceDependency container = ServiceDependency.on((UnaryServiceDescriptor)InfinispanServiceDescriptor.CACHE_CONTAINER, (String)containerName);
            final ServiceDependency dispatcherFactory = ServiceDependency.on((UnaryServiceDescriptor)ClusteringServiceDescriptor.COMMAND_DISPATCHER_FACTORY, (String)channelName).map(ChannelCommandDispatcherFactory.class::cast);
            ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration configuration = new ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration(){

                public EmbeddedCacheManager getCacheContainer() {
                    return (EmbeddedCacheManager)container.get();
                }

                public GroupCommandDispatcherFactory<Address, ChannelGroupMember> getCommandDispatcherFactory() {
                    return (GroupCommandDispatcherFactory)dispatcherFactory.get();
                }
            };
            return (ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder(EmbeddedCacheManagerCommandDispatcherFactory::new, (Supplier)Functions.constantSupplier((Object)configuration)).provides(support.getCapabilityServiceName(ClusteringServiceDescriptor.COMMAND_DISPATCHER_FACTORY, containerName))).requires(List.of(container, dispatcherFactory))).build();
        }
    }
    ,
    LOCAL{

        @Override
        public ServiceInstaller apply(CapabilityServiceSupport support, Map.Entry<String, String> entry) {
            String containerName = entry.getKey();
            final ServiceDependency container = ServiceDependency.on((UnaryServiceDescriptor)InfinispanServiceDescriptor.CACHE_CONTAINER, (String)containerName);
            LocalEmbeddedCacheManagerCommandDispatcherFactoryConfiguration configuration = new LocalEmbeddedCacheManagerCommandDispatcherFactoryConfiguration(){

                public EmbeddedCacheManager getCacheContainer() {
                    return (EmbeddedCacheManager)container.get();
                }
            };
            return (ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder(EmbeddedCacheManagerCommandDispatcherFactory::new, (Supplier)Functions.constantSupplier((Object)configuration)).provides(support.getCapabilityServiceName(ClusteringServiceDescriptor.COMMAND_DISPATCHER_FACTORY, containerName))).requires(List.of(container))).build();
        }
    };

}

